(function () {
    'use strict';
    var serviceId = 'announcementdataservices';

    // TODO: replace app with your module name
    churchplusapp.factory(serviceId, ['$http', '$q', announcementdataservices]);

    function announcementdataservices($http, $q) {
        // Define the functions and properties to reveal.

        var _announcements = [];
        
        var _initannouncements = false;

        var service = {
            announcements: _announcements,            
            getannouncementsData: getannouncementsData,
            addAnnouncementData : addAnnouncementData,
            removeannouncementData: removeannouncementData,
            IsannouncementDataInitialized: IsannouncementDataInitialized,
            getAnnouncementDataForEdit: getAnnouncementDataForEdit
           // getannouncementDataForEdit: getannouncementDataForEdit
        };

        return service;

       
        //function for getting all the announcements

        function getannouncementsData() {
            var deferred = $q.defer();

            $http.get('api/AnnoucementsController/GetAnnoucmentsData').then(function (result) {
                //successful call
                angular.copy(result.data, _announcements);
                _initannouncements = true;

                deferred.resolve();
            },
            function () {
                //error in call
                deferred.reject();
            });
            return deferred.promise;
        }

        

        //function for add an announcement

        function addAnnouncementData(announcementData) {
            var deferred = $q.defer();

            var announcementDataToEdit;
            if (announcementData.id != null) {
                announcementDataToEdit = announcementData;
            }
            $http.post('/api/AnnoucementsController/SaveAnnoucment', announcementData).then(function (result) {
               
                if (announcementDataToEdit != null) {                    
                    for (var i = 0; _announcements.length > i; i++) {
                        if (_announcements[i].id === announcementData.id) {
                            //console.log(i);
                            _announcements.splice(i, 1, announcementData);
                            break;
                        }
                    }


                } else {
                    _announcements.splice(0, 0, result.data);                  

                }                

                deferred.resolve(result.data);

            }, function (result) {

                deferred.reject(result.data);
            });

            return deferred.promise;

        }


        function getAnnouncementDataForEdit(id) {
            var deferred = $q.defer();

            $http({
                method: 'get',
                url: 'api/AnnoucementsController/GetSingleAnnoucment',
                params: { id: id }
            }).then(function (result) {
                //successful call

                deferred.resolve(result.data);
            },
            function () {
                //error in call
                deferred.reject();
            });
            return deferred.promise;

        }


        function removeannouncementData(announcementDataID) {
            var deferred = $q.defer();

            $http({
                method: 'delete',
                url: 'api/AnnoucementsController/DeleteAnnoucment',
                params: {ID: announcementDataID}
            })
                .then(function (result) {
                    for (var i = 0; _announcements.length > i; i++) {
                        if (_announcements[i].id === announcementDataID) {                           
                            _announcements.splice(_announcements.indexOf(_announcements[i]), 1);
                            break;
                        }
                        
                    }                    
                    deferred.resolve(result.data);
            },
            function () {
                deferred.reject();
            });

            return deferred.promise;

            //$http.delete('api/AnnoucementsController/DeleteAnnoucment' + announcementData.id)
            //    .then(function (result) {
            //        _announcements.splice(_announcements.indexOf(announcementData), 1);
            //        deferred.resolve(announcementData);

            //}, function (result) {

            //    deferred.reject(result);
            //});

            //return deferred.promise;

        }


        function IsannouncementDataInitialized() {
            return _initannouncements;
        }


    }
    
})();
