﻿(function () {
    'use strict';

    var serviceId = 'eventsDataService';

    // TODO: replace app with your module name
    churchplusapp.factory(serviceId, ['$http', '$q', eventsDataService]);

    function eventsDataService($http, $q) {
        // Define the functions and properties to reveal.

        var _eventsData = [];
        var _activitiesReportData = [];

        var _initEventData = false;
        var _initActivitiesReportData = false;

        var service = {
            eventsData: _eventsData,
            activitiesReportData: _activitiesReportData,
            getEventsData: getEventsData,
            getEventDataByID:getEventDataByID,
            IsEventsReportDataInitialised: IsEventsReportDataInitialised,
            IsEventsDataInitialised: IsEventsDataInitialised,
            getActivitiesReportData: getActivitiesReportData,
            getActivitiesReportDataByID: getActivitiesReportDataByID,
            removeAttendanceData: removeAttendanceData,
            removeFirstTimerData: removeFirstTimerData,
            removeActivityReportData: removeActivityReportData,
            removeEventData: removeEventData,
            removeEventReminderData:removeEventReminderData,
            removeConvertData: removeConvertData,
            saveActivitiesReport: saveActivitiesReport,
            saveCommitActivitiesReport: saveCommitActivitiesReport,
            saveChurchEventData: saveChurchEventData

        };

        return service;

        function getEventsData() {
            var deferred = $q.defer();
         
                $http.get('api/EventsController/getAllEvents').then(function (result) {
                    //successful call
                    angular.copy(result.data, _eventsData);
                    _initEventData = true;

                    deferred.resolve();
                },
                function () {
                    //error in call
                    deferred.reject();
                });
             
            return deferred.promise;
        }

        function getActivitiesReportData() {
            var deferred = $q.defer();
            $http.get('api/EventsController/getAllEventsReports').then(function (result) {
                //successful call
                angular.copy(result.data, _activitiesReportData);
                _initActivitiesReportData = true;

                deferred.resolve();
            },
                function () {
                    //error in call
                    deferred.reject();
                });

            return deferred.promise;
        }
        
        function getEventDataByID(EventID) {
            var deferred = $q.defer();
            $http({
                method: 'get',
                url: 'api/EventsController/getSingleEvent',
                params: { Id: EventID }
            }).then(function (result) {
                //successful call

                deferred.resolve(result.data);
            },
                function () {
                    //error in call
                    deferred.reject();
                });

            return deferred.promise;
        }
        function getActivitiesReportDataByID(ActivityID) {
            var deferred = $q.defer();
            $http({
                method: 'get',
                url: 'api/EventsController/getSingleEventsReport',
                params: { Id: ActivityID }
            }).then(function (result) {
                //successful call

                deferred.resolve(result.data);
            },
                function () {
                    //error in call
                    deferred.reject();
                });

            return deferred.promise;
        }
        function IsEventsReportDataInitialised() {
            return _initActivitiesReportData;
        }

        function IsEventsDataInitialised() {
            return _initEventData;
        }

        function removeAttendanceData(attendanceID) {
            var deferred = $q.defer();
            $http({
                method: 'delete',
                url: 'api/EventsController/deleteEventsReportAttendance',
                params: { attendanceID: attendanceID }
            }).then(function (result) {
                //successful call
                deferred.resolve(result.data);
            },
                function () {
                    //error in call
                    deferred.reject();
                });

            return deferred.promise;
         }
        //This function calls the Event delete functionality of the webAPI
        function removeEventData(EventData) {
            var deferred = $q.defer();
            $http({
                method: 'delete',
                url: 'api/EventsController/deleteEventData',
                params: { ID: EventData.id }
            }).then(function (result) {
                //successful call
                _eventsData.splice(_eventsData.indexOf(EventData), 1);
                deferred.resolve(result.data);
            },
                function () {
                    //error in call
                    deferred.reject();
                });

            return deferred.promise;
        }


        //This function calls the Event Reminder delete functionality of the webAPI
        function removeEventReminderData(EventReminderID) {
            var deferred = $q.defer();
            $http({
                method: 'delete',
                url: 'api/EventsController/deleteEventReminderData',
                params: { ID: EventReminderID }
            }).then(function (result) {
                //successful call
                deferred.resolve(result.data);
            },
                function () {
                    //error in call
                    deferred.reject();
                });

            return deferred.promise;
        }

        function removeFirstTimerData(firstTimer) {
            var contacts = [];
            contacts.push({ id: firstTimer.personID, otherInfo: firstTimer.id });

            var deferred = $q.defer();
            $http.post('/api/MembershipController/RemoveFirstTimerFromDatabase/', contacts).then(function (result) {
                //successful call
                deferred.resolve(firstTimer);
            },
                function () {
                    //error in call
                    deferred.reject();
                });

            return deferred.promise;

        }

        function removeConvertData(convert) {
            var contacts = [];
            contacts.push({ id: convert.personID, otherInfo: convert.id });

            var deferred = $q.defer();
            $http.post('api/MembershipController/RemoveNewConvertsFromDatabase', contacts).then(function (result) {
                //successful call
                deferred.resolve(convert);
            },
                function () {
                    //error in call
                    deferred.reject();
                });

            return deferred.promise;

        }

        //This method is called by te first timer add function for a temporary Add
        function saveActivitiesReport(activityReport) {

            var deferred = $q.defer();
            $http.post('api/EventsController/saveActivityReport', activityReport).then(function (result) {
                //successful call
                deferred.resolve(result.data);
            },
                function () {
                    //error in call
                    deferred.reject();
                });

            return deferred.promise;

        }

        //This function is called by the save function, it saves and transfers the application to the activities list page
        function saveCommitActivitiesReport(activityReport) {

            var deferred = $q.defer();
            $http.post('api/EventsController/saveCommitActivityReport', activityReport).then(function (result) {
                //successful call
                if (activityReport.id != null) {

                    for (var i = 0; i < _activitiesReportData.length; i++) {

                        if (_activitiesReportData[i].id == activityReport.id) {
                            _activitiesReportData.splice(_activitiesReportData.indexOf(_activitiesReportData[i]), 1);

                        }
                    }

                }
                _activitiesReportData.splice(0, 0, result.data);

                deferred.resolve();
            },
                function () {
                    //error in call
                    deferred.reject();
                });

            return deferred.promise;

        }

        //This function sends the event to the data store
        function saveChurchEventData(churchEvent)
        {
            var deferred = $q.defer();
            $http.post('api/EventsController/saveChurchEventData', churchEvent).then(function (result) {
                //successful call
                if (churchEvent.id != null) {

                    for (var i = 0; i < _eventsData.length; i++) {

                        if (_eventsData[i].id == churchEvent.id) {
                            _eventsData.splice(_eventsData.indexOf(_eventsData[i]), 1);

                        }
                    }

                }
                _eventsData.splice(0, 0, result.data);
                deferred.resolve();
            },
                function () {
                    //error in call
                    deferred.reject();
                });

            return deferred.promise;

        }
        //This function deletes the activities from the database
        function removeActivityReportData(p) {
            var deferred = $q.defer();
            $http({
                method: 'delete',
                url: 'api/EventsController/deleteActivityReport',
                params: { ID: p.id }
            }).then(function (result) {
                //successful call
                //remove the item from the database
                _activitiesReportData.splice(_activitiesReportData.indexOf(p), 1);
                deferred.resolve();
            },
                function () {
                    //error in call
                    deferred.reject();
                });

            return deferred.promise;


        }


    }
})();