(function () {
    'use strict';
    var controllerId = 'financialTransactionController';
    // TODO: replace app with your module name
    churchplusapp.controller(controllerId,
        ['$scope', 'accountingDataServices', 'financialTransactionDataService', '$timeout', 'notificationFactory', 'ngTableParams', '$filter', financialTransactionController]);

    function financialTransactionController($scope, accountingDataServices,financialTransactionDataService, $timeout, notificationFactory, ngTableParams, $filter) {
        var AccountingTransaction = {};

        $scope.title = 'financialTransactionController';
        $scope.activate = activate;
        $scope.activateFinancialModule = activateFinancialModule;
        $scope.data =  accountingDataServices;
        
        $scope.SaveExpenseTransaction = SaveExpenseTransaction;
        $scope.AccountingTransaction = AccountingTransaction;
        $scope.financialTransactionData = [];

        $scope.abs = Math.abs;
     
        ///Check if the application has the setup accouting for this system else popup for the user to setup the accounting module.

        if (accountingDataServices.IsBoolCheckAccountDataInitialised() == false) {

            accountingDataServices.IsAccountingModuleInitialized().then(function (data) {

                //if this is false then popup the modal popup for the user.
                if (data.toString() == 'false') {

                    // $('#Activation_modal').show('Modal');                      
                    $timeout(function () {
                        $('#Activation_modal').modal('show');
                    }, 1000);
                }

            }, function () { });


        } else {
            //load the recent income and expense transactions of the ministry
          
        }

        //load the Expense accounts
        accountingDataServices.getExpenseAccountsData().then(function (expenseAccount) {
            $("#select-expenseAccount").select2({
                placeHolder: '--select Expense Account--',
                data: expenseAccount,
                width: "100%"
            });
        }, function () { });

        //load the cash accounts
        accountingDataServices.getAssetAccountsData().then(function (cashAccount) {
            $("#select-cashAccount").select2({
                placeHolder: '--select cash Account--',
                data: cashAccount,
                width: "100%"
            });
        }, function () { });

        //load transactions
        loadIncomeExpenseData();

        function activateFinancialModule() {
            notificationFactory.info('Activating the Accounting the accounting module, this will take some seconds.');
            accountingDataServices.InitializeAccountingModule().then(function (result) {

                if (result.toString() == 'true') {
                    notificationFactory.success('Accounting Module Successfully Activated.');
                } else {
                    notificationFactory.error('Accounting Module Not Successfully Activated.');

                }


            }, function () { });

        }

        function ngTableFunction(result) {
            $scope.tableParams = new ngTableParams({
                page: 1,            // show first page
                count: 10,           // count per page
                sorting: {
                    date: 'desc'     // initial sorting
                }, filter: {
                    memo: ''       // initial filter
                },
            }, {
                total: result.length, // length of data
                getData: function ($defer, params) {

                    // use build-in angular filter
                    var filteredData = params.filter() ?
                            $filter('filter')(result, params.filter()) :
                            result;
                    var orderedData = params.sorting() ?
                            $filter('orderBy')(filteredData, params.orderBy()) :
                           result;
                    params.total(orderedData.length); // set total for recalc pagination                    
                    $defer.resolve(orderedData.slice((params.page() - 1) * params.count(), params.page() * params.count()));

                    $("th").removeClass("filter ng-scope");

                }
            });
            $scope.tableParams.settings().$scope = $scope;
        }

		function activate() { }
        $(".datepicker").datepicker({
            showOtherMonths: true
        });

        //Method to load the transactions
        function loadIncomeExpenseData() {
            accountingDataServices.getIncomeExpenseTransaction().then(function (result) {
                $scope.financialTransactionData = result;
                ngTableFunction($scope.financialTransactionData);

            }, function () { });
        }

        //The Method saves the expense Transaction
        function SaveExpenseTransaction()
        {
            if ($scope.AccountingTransaction.Amount == "") {
                notificationFactory.error('You have to enter a valid amount ')
                return;
            }
            if ($("#select-expenseAccount").val() == "") {
                notificationFactory.error('You have to select the expense account')
                return;
            }
            if ($("#select-cashAccount").val() == "") {
                notificationFactory.error('You have select the account you are spending the money from')
                return;
            }
			
            $scope.AccountingTransaction.DebitAccountID = $('#select-expenseAccount').val();
            $scope.AccountingTransaction.CreditAccountID = $('#select-cashAccount').val();

            accountingDataServices.saveExpenseTransaction($scope.AccountingTransaction).then(function (result) {
                //successful
                //clear the fields and add to the collection.
                if (result.status == true) {
                    notificationFactory.success("The Expense saved successfully");

                    accountingDataServices.getIncomeExpenseTransaction().then(function (result) {
                        $scope.tableParams.reload();
                        ngTableFunction(result);
                        $timeout(function () {                        
                        }, 100);
                    }, function () { });
                } else {
                    notificationFactory.error(result.Responce + " Operation was not successful, refresh your browser and try again");
                }
            }, function () {
                notificationFactory.error("Operation was not successful, refresh your browser and try again");
            });
        }
        // The delete function for the income/expense
        // The funcation also deletes the contribution of the income account.
        $scope.remove = function (dataId, index) {
            if (confirm("Do you want to delete the record?")) {
                financialTransactionDataService.delete(dataId)
                    .then(function (result) {
                        notificationFactory.success('Deleted successfully!');
                        loadIncomeExpenseData();
                        $scope.financialTransactionData.splice(index, 1);
                    }, function () {
                        notificationFactory.error('Delete NOT successfull!');
                    });
            }
        };
    }
})();
