﻿(function () {
    'use strict';

    var controllerId = 'groupNewEditController';

    // TODO: replace app with your module name
    churchplusapp.controller(controllerId,
         ['$scope', '$http', '$window', '$routeParams', 'dataservices','groupdataservices', 'notificationFactory', groupneweditcontroller]);

    function groupneweditcontroller($scope, $http, $window, $routeParams, dataservices,groupdataservices, notificationFactory) {
        $scope.title = 'groupneweditcontroller';
        $scope.activate = activate;
        $scope.group = { peopleInGroups:[]};
        $scope.selectionValue = false;
        $scope.AnySelection = false;


        if ($routeParams.id == null) {

        }
        else {
            groupdataservices.getGroupDataForEdit($routeParams.id).then(function (group) {

                $scope.group = group;

            }, function () {
                //Use Toaster Alert Note
                notificationFactory.error("Getting the group Information, try again");

            })

        }


        $('#personselect')
            .select2({
            placeholder: 'Select Person From Membership Data',
            multiple: true, 
            minimumInputLength: 3,
            query: function (query) {
                dataservices.getPersonSearch(query.term).then(function (data) {

                    query.callback({results:data});

                   // return data;
                }, function () { });
            },
            width: "100%"
            }
            );





        //load the email drafts
        dataservices.getEmailDrafts().then(function (emails) {

            $("#emaildraftselect").select2({
                placeholder: 'Select From Drafts',
                data: emails,
                width: "100%"         //

            }).on("change", function (e) {

                //call the get email service

                dataservices.getEmailDraftByID(e.val).then(function (emaildraft) {

                    $scope.emailSubject = emaildraft.subject;
                    $scope.emailMessage = emaildraft.message;
                    $('#emailMessage').data("wysihtml5").editor.setValue(emaildraft.message);


                }, function () {
                    //error
                    notificationFactory.error("Unsuccessful");

                });

            });

        }, function () {
            // Error
        });

        dataservices.getSMSDrafts().then(function (sms) {
            $("#smsdraftselect").select2({
                placeholder: 'Select From SMS Drafts',
                data: sms,
                width: "100%"
            }).on("change", function (e) {

                //call the get email service

                dataservices.getSMSDraftByID(e.val).then(function (smsdraft) {

                    $scope.smsSubject = smsdraft.sender;
                    $scope.smsMessage = smsdraft.body;

                }, function () {

                    //Error
                    notificationFactory.error("Unsuccessful");

                });

            });

        }, function () {
            //Error
        });

        $scope.SaveGroup = function () {
           
            groupdataservices.addGroupData($scope.group).then(function (result) {
                $window.location = "#/Groups"
            }, function () {
                notificationFactory.error("Unsuccessful Operation");

            });
        }

        $scope.Cancel = function () {
            alert('cancel Save');

        }

        $scope.RemoveGroupMember = function (gm) {

            if (gm.id == null)
            {
                $scope.group.peopleInGroups.splice($scope.group.peopleInGroups.indexOf(gm), 1);
                notificationFactory.success();

            } else {           

                groupdataservices.removeGroupMemberData(gm).then(function (r) {
                    $scope.group.peopleInGroups.splice($scope.group.peopleInGroups.indexOf(gm), 1);
                notificationFactory.success();
            }, function (r) {

                notificationFactory.error(r);
            });
 }
        }

        $scope.UpdateAllSelection = function (peopleArray, selectionValue) {

            for (var i = 0; i < peopleArray.length; i++) {
                peopleArray[i].isSelected = selectionValue;
            }
        }
        $scope.SendSMS = function () {

            if (getSelectedMembers().length < 1) {
                notificationFactory.error('Please select contact to send sms');
            }
            else {


                var messageObject = {};
                messageObject.subject = $scope.smsSubject;
                messageObject.message = $scope.smsMessage;
                messageObject.contacts = getSelectedMembers();
                //check if the client has enough unit to send sms


                //If true then send the sms.
                dataservices.sendSMS(messageObject).then(function () {

                    notificationFactory.success('SMS successfully sent');

                }, function () {

                    notificationFactory.error('There was an error sending SMS, please check your internet connection and try again.');

                });
            }

        }
        $scope.SendEmail = function () {

            if (getSelectedMembers().length < 1) {
                notificationFactory.error('Please select contact to send email');
            }
            else {
                var messageObject = {};
                messageObject.subject = $scope.emailSubject;
                messageObject.message = $scope.emailMessage;
                messageObject.contacts = getSelectedMembers();
                //post this to the dataservice factory that will serve as the common functionality base.

                dataservices.sendEmails(messageObject).then(function () {
                    notificationFactory.success('Emails successfully sent');
                }, function () {
                    // error
                    notificationFactory.error('There was an error sending email, please check your internet connection and try again.');
                });
            }
        }

        function getSelectedMembers() {
            var contactArray = [];
            for (var i = 0; i < $scope.group.peopleInGroups.length; i++) {

                if ($scope.group.peopleInGroups[i].isSelected == true) {
                    var contact = {};

                    contact.id = $scope.group.peopleInGroups[i].id;
                    contact.name = $scope.group.peopleInGroups[i].name;
                    contact.phone = $scope.group.peopleInGroups[i].phone;
                    contact.email = $scope.group.peopleInGroups[i].email;
                    contactArray.push(contact);
                }
            }

            return contactArray;
        }
        //Add People to the groups function, this does not save the information to the system all save are handled by the save function
        $scope.AddGroupMember = function () {

            var selectMembersID = $('#personselect').val();

            dataservices.getPeopleInformation(selectMembersID).then(function (result) {

                $.each(result, function (i, person) {
                
                    var PeronsInGroup = {};
                    PeronsInGroup.person = person;
                    PeronsInGroup.personID = person.id;
                    PeronsInGroup.dateJoined = Date.now();
                    PeronsInGroup.groupID = $scope.group.id;
                    PeronsInGroup.position = $scope.memberPosition;
                    $scope.group.peopleInGroups.splice(0, 0, PeronsInGroup);

                    $('#personselect').val('');

                })
            }, function () {
                notificationFactory.error("Unsuccessful Operation");

            });
        }

        $('.editor').wysihtml5({
            stylesheets: "css/wysihtml5/wysiwyg-color.css"
        });




        $(".datepicker").datepicker({
            showOtherMonths: true
        });

       
        function activate() { }
    }
})();
