﻿
(function () {
    'use strict';

    var controllerId = 'houseFellowshipsController';

    // TODO: replace app with your module name
    churchplusapp.controller(controllerId,
        ['$scope', '$window', 'cellFellowshipDataServices', 'notificationFactory', 'dataservices', '$filter', 'ngTableParams', houseFellowshipsController]);

    function houseFellowshipsController($scope, $window, cellFellowshipDataServices, notificationFactory, dataservices, $filter, ngTableParams) {

        $scope.title = 'houseFellowshipsController';
        $scope.data = cellFellowshipDataServices.houseFellowshipData;

        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

        // @ Check Initialization....
        if (cellFellowshipDataServices.isHouseFellowshipDataInitialized() == false) {

            //@ Get Data
            cellFellowshipDataServices.getAllHouseFellowshipData()
                .then(function () {
                    //@ Success  
                    //$scope.data = data2
                },
         function () {
             //@ Failure
             notificationFactory.error('Error loading data...');
         });
        }
            
        ///////////////////////////////////////////////////////////////////////////////////////////////////////*

        $scope.tableParams = new ngTableParams({
            page: 1,            // show first page
            count: 10,          // count per page
            sorting: {
                name: 'asc'     // initial sorting
            }
        }, {
            total: $scope.data.length, // length of data
            getData: function ($defer, params) {
                // use build-in angular filter
                var orderedData = params.sorting() ? $filter('orderBy')($scope.data, params.orderBy()) : $scope.data;
                $defer.resolve(orderedData.slice((params.page() - 1) * params.count(), params.page() * params.count()));
            }
        });


        ///////////////////////////////////////////////////////////////////////////////////////////////////////

        //Refresh Data
        $scope.Refresh = function () {
                cellFellowshipDataServices.getAllHouseFellowshipData()
                    .then(function () {
                        //@ Success

                    },
                    function () {
                        //Error refreshing data set
                        notificationFactory.error('Can not retrive data from the server now, please check internet connections and try again');
                    });
        }

        //Single Data
        $scope.SingleData = function (x) {

            cellFellowshipDataServices.getSingleHouseFellowshipData(x)
                .then(function () {
                    //@ Success

                },
                function () {
                    //Error refreshing data set
                    notificationFactory.error('Can not retrive data from the server now, please check internet connections and try again');
                });;
        }

        //Remove Data
        $scope.Remove = function (a) {
            if (confirm("Are you sure you want to delete this house fellowship")) {
                cellFellowshipDataServices.deleteHouseFellowshipData(a)
                    .then(function (a) {
                        //@ Success

                        notificationFactory.success(a.id + ' removed');
                    }, function (a) {
                        //@ Error

                        notificationFactory.error(a);
                    });
            }
        }

        $scope.Goto = function (url) {
            $window.location = url;
        }

    }
})();
