﻿(function () {
    'use strict';

    var serviceId = 'prayerDataServices';

    // TODO: replace app with your module name
    churchplusapp.factory(serviceId, ['$http', '$q', prayerDataServices]);

    function prayerDataServices($http, $q) {
        // Define the functions and properties to reveal.       

        var _prayerPoints = [];

        var _prayerRequests = [];

        var _initPrayerPoints = false;
        var _initPrayerRequests = false;

        var service = {

            prayerPoints: _prayerPoints,
            prayerRequests: _prayerRequests,

            getPrayerPointsData: getPrayerPointsData,
            getPrayerRequestsData: getPrayerRequestsData,

            addPrayerPointData: addPrayerPointData,
            addPrayerRequestData: addPrayerRequestData,

            removePrayerPointData: removePrayerPointData,
            removePrayerRequestData: removePrayerRequestData,

            getPrayerPointDataForEdit: getPrayerPointDataForEdit,
            getPrayerRequestDataForEdit:getPrayerRequestDataForEdit,
            
            IsPrayerPointsDataInitialized: IsPrayerPointsDataInitialized,
            IsPrayerRequestsDataInitialized: IsPrayerRequestsDataInitialized            
        };


        return service;

        //function for initializing prayer points data
        function IsPrayerPointsDataInitialized() {
            return _initPrayerPoints;
        }

        //function for initializing prayer requests data
        function IsPrayerRequestsDataInitialized() {
            return _initPrayerRequests;
        }

        //function for getting all the prayers points

        function getPrayerPointsData() {
            var deferred = $q.defer();

            $http.get('api/prayerPointController/GetPrayerPointData').then(function (result) {
                //successful call
                angular.copy(result.data, _prayerPoints);               
                
                angular.forEach(_prayerPoints, function (value) {
                    value.type = "Prayer Point"
                });

                _initPrayerPoints = true;

                deferred.resolve();
            },
            function () {
                //error in call
                deferred.reject();
            });

            return deferred.promise;
        }

        //function for getting all the prayers requests
        function getPrayerRequestsData() {
            var deferred2 = $q.defer();

            $http.get('api/prayerRequestController/GetPrayerRequestData').then(function (result) {
                //successful call
                angular.copy(result.data, _prayerRequests);
                angular.forEach(_prayerRequests, function (value) {
                    value.type = "Prayer Request"
                });
                _initPrayerRequests = true;

                deferred2.resolve();
            },
            function () {
                //error in call
                deferred2.reject();
            });


            return deferred2.promise;
        }



        //function for adding and editing a prayer point

        function addPrayerPointData(prayerPointData) {
            var deferred = $q.defer();

            var prayerPointDataToEdit;
            if (prayerPointData.id != null) {
                prayerPointDataToEdit = prayerPointData;
            }

            $http.post('api/prayerPointController/SavePrayerPoint', prayerPointData).then(function (result) {

                if (prayerPointDataToEdit != null) {
                    for (var i = 0; _prayerPoints.length > i; i++) {
                        if (_prayerPoints[i].id === prayerPointData.id) {
                            
                            _prayerPoints.splice(i, 1, prayerPointData);
                            console.log(_prayerPoints);
                            break;
                        }
                    }
                } else {
                    console.log(result.data);
                    _prayerPoints.splice(0, 0, result.data);
                }
                deferred.resolve(result.data);
            }, function (result) {
                deferred.reject(result.data);
            });
            return deferred.promise;
        }

        //function for adding and editing a prayer request

        function addPrayerRequestData(prayerRequestData) {
            var deferred = $q.defer();

            var prayerRequestDataToEdit;
            if (prayerRequestData.id != null) {
                prayerRequestDataToEdit = prayerRequestData;
            }

            $http.post('api/prayerRequestController/SavePrayerRequest', prayerRequestData).then(function (result) {

                if (prayerRequestDataToEdit != null) {
                    for (var i = 0; _prayerRequests.length > i; i++) {
                        if (_prayerRequests[i].id === prayerRequestData.id) {
                            //console.log(i);
                            _prayerRequests.splice(i, 1, prayerRequestData);
                            break;
                        }
                    }
                } else {
                    _prayerRequests.splice(0, 0, result.data);
                }
                deferred.resolve(result.data);
            }, function (result) {
                deferred.reject(result.data);
            });
            return deferred.promise;
        }



        //function for getting a single prayer point data
        function getPrayerPointDataForEdit(id) {
            var deferred = $q.defer();

            $http({
                method: 'get',
                url: 'api/prayerPointController/GetSinglePrayerPoint',
                params: { id: id }
            }).then(function (result) {
                //successful call
                deferred.resolve(result.data);
            },
            function () {
                //error in call
                deferred.reject();
            });
            return deferred.promise;
        }

        //function for get a single prayer request data

        function getPrayerRequestDataForEdit(id) {
            var deferred = $q.defer();

            $http({
                method: 'get',
                url: 'api/prayerRequestController/GetSinglePrayerRequest',
                params: { id: id }
            }).then(function (result) {
                //successful call
                deferred.resolve(result.data);
            },
            function () {
                //error in call
                deferred.reject();
            });
            return deferred.promise;
        }

        //function for removing prayer point data

        function removePrayerPointData(prayerPointDataID) {
            var deferred = $q.defer();

            $http({
                method: 'delete',
                url: 'api/prayerPointController/DeletePrayerPoint',
                params: { ID: prayerPointDataID }
            }).then(function (result) {
                    for (var i = 0; _prayerPoints.length > i; i++) {
                        if (_prayerPoints[i].id === prayerPointDataID) {
                            _prayerPoints.splice(_prayerPoints.indexOf(_prayerPoints[i]), 1);
                            break;
                        }

                    }
                    deferred.resolve(result.data);
                },
            function () {
                deferred.reject();
            });

            return deferred.promise;
        }

        //function for removing prayer request data

        function removePrayerRequestData(prayerRequestDataID) {
            var deferred = $q.defer();

            $http({
                method: 'delete',
                url: 'api/prayerRequestController/DeletePrayerRequest',
                params: { ID: prayerRequestDataID }
            }).then(function (result) {
                for (var i = 0; _prayerRequests.length > i; i++) {
                    if (_prayerRequests[i].id === prayerRequestDataID) {
                        _prayerRequests.splice(_prayerRequests.indexOf(_prayerRequests[i]), 1);
                        break;
                    }

                }
                deferred.resolve(result.data);
            },
            function () {
                deferred.reject();
            });

            return deferred.promise;
        }

        function activate() { }
    }
 
})();
