(function() {
    'use strict';

    var serviceId = 'accountingDataServices';

    // TODO: replace app with your module name
    churchplusapp.factory(serviceId, ['$http', '$q', accountingDataServices]);


    function accountingDataServices($http, $q) {
        // Define the functions and properties to reveal.
        var _chartOfAccountData = [];
        var _ContributionAccountData = [];
        var _SingleContributionAccountData = {};

        var _initChartOfAccountData = false;
        var _initBoolCheckAccountInitializedData = false;
        var _initContributionInitializedData = false;
        var _IncomeExpenseTransaction = [];

        var service = { 

            ChartOfAccountData: _chartOfAccountData,
            ContributionAccountData: _ContributionAccountData,
            SingleContributionAccountData: _SingleContributionAccountData,
            IncomeExpenseTransactionData: _IncomeExpenseTransaction,

            getChartOfAccountsData: getChartOfAccountsData,
            getContributionAccountsData: getContributionAccountsData,
            getSingleContributionAccountsData: getSingleContributionAccountsData,
            getIncomeAccountsData: getIncomeAccountsData,
            getExpenseAccountsData: getExpenseAccountsData,
            getCashAccountsData: getCashAccountsData,
            getAssetAccountsData: getAssetAccountsData,
            getLiabilityAccountsData:getLiabilityAccountsData,
            getIncomeExpenseTransaction: getIncomeExpenseTransaction,
            //////////////////////////////////////////

            saveContributionCategory: saveContributionCategory,
            saveContributionTransaction: saveContributionTransaction,
            saveOtherIncomeTransaction:saveOtherIncomeTransaction,
            saveExpenseTransaction: saveExpenseTransaction,
            removeContributionCategoryData: removeContributionCategoryData,


            InitializeAccountingModule: InitializeAccountingModule,
            IsAccountingModuleInitialized: IsAccountingModuleInitialized,

            IsChartOfAccountDataInitialised: IsChartOfAccountDataInitialised,
            IsBoolCheckAccountDataInitialised: IsBoolCheckAccountDataInitialised,
            IsContributionAccountDataInitialised: IsContributionAccountDataInitialised
        };


        return service;

        function getIncomeExpenseTransaction() {
            var deferred = $q.defer();
            $http.get('api/AccountingFinancialController/GetFinancialIncomeAndExpenseTransactions')
                .then(function(result) {
                        //successful call
                        angular.copy(result.data, _IncomeExpenseTransaction);
                        //  angular.copy(result.data, _firstTimersData);
                        deferred.resolve(_IncomeExpenseTransaction);
                    },
                    function() {
                        //error in call
                        deferred.reject();
                    });

            return deferred.promise;
        }
      
        function getExpenseAccountsData() {
            var deferred = $q.defer();
            $http.get('api/AccountingFinancialController/GetExpenseAccounts')
                .then(function(result) {
                        //successful call
                        deferred.resolve(result.data);
                    },
                    function() {
                        //error in call
                        deferred.reject();
                    });
            return deferred.promise;
        }

        function getChartOfAccountsData() {
            var deferred = $q.defer();
            $http.get('api/AccountingFinancialController/GetChartOfAccounts')
                .then(function(result) {
                        //successful call
                        angular.copy(result.data, _chartOfAccountData);
                        _initChartOfAccountData = true;
                        deferred.resolve(result.data);
                    },
                    function() {
                        //error in call
                        deferred.reject();
                    });

            return deferred.promise;
        }

        function getContributionAccountsData() {
            var deferred = $q.defer();

            $http.get('api/AccountingFinancialController/GetFinancialOfferingTypesContributions')
                .then(function(result) {
                        //successful call
                        angular.copy(result.data, _ContributionAccountData);
                        _initContributionInitializedData = true;
                        deferred.resolve(result.data);
                    },
                    function() {
                        //error in call
                        deferred.reject();
                    });
            return deferred.promise;
        }

        function getSingleContributionAccountsData(id) {
            var deferred = $q.defer();
            $http({
                method: 'get',
                url: 'api/AccountingFinancialController/GetSingleFinancialOfferingTypesContribution',
                params: {
                    id: id
                }
            }).then(function (result) {
                angular.copy(result.data, _SingleContributionAccountData);
                _initContributionInitializedData = true;
                deferred.resolve(result.data);

            }, function (result) {

                deferred.reject(result);
            });

            return deferred.promise;

        }

        function getIncomeAccountsData() {
            var deferred = $q.defer();
            $http.get('api/AccountingFinancialController/GetIncomeAccounts')
                .then(function(result) {
                        //successful call
                        deferred.resolve(result.data);
                    },
                    function() {
                        //error in call
                        deferred.reject();
                    });
            return deferred.promise;
        }
        
        function getAssetAccountsData() {
            var deferred = $q.defer();
            $http.get('api/AccountingFinancialController/GetAssetAccounts')
                .then(function (result) {
                    //successful call
                    deferred.resolve(result.data);
                },
                    function () {
                        //error in call
                        deferred.reject();
                    });
            return deferred.promise;
        }
        function getLiabilityAccountsData() {
            var deferred = $q.defer();
            $http.get('api/AccountingFinancialController/GetLiabilityAccounts')
                .then(function (result) {
                    //successful call
                    deferred.resolve(result.data);
                },
                    function () {
                        //error in call
                        deferred.reject();
                    });
            return deferred.promise;
        }

        function getCashAccountsData() {
            var deferred = $q.defer();
            $http.get('api/AccountingFinancialController/GetCashBankAccounts')
                .then(function(result) {
                        //successful call
                        deferred.resolve(result.data);
                    },
                    function() {
                        //error in call
                        deferred.reject();
                    });
            return deferred.promise;
        }

        function saveContributionCategory(contribution) {
            var deferred = $q.defer();
            $http.post('api/AccountingFinancialController/SaveOfferingTypesContributions', contribution)
                .then(function(result) {
                    //successful call
                    deferred.resolve(result.data);
                }, function() {
                    //error in call
                    deferred.reject();
                });
            return deferred.promise;
        }
        function saveOtherIncomeTransaction(Income) {
            var deferred = $q.defer();
            $http.post('api/AccountingFinancialController/SaveOtherIncomeTransaction', Income)
                .then(function (result) {
                    //successful call
                    deferred.resolve(result.data);
                }, function () {
                    //error in call
                    deferred.reject();
                });
            return deferred.promise;
        }

        function saveContributionTransaction(contributionTransaction) {
            var deferred = $q.defer();
            $http.post('api/AccountingFinancialController/SaveContributionTransaction', contributionTransaction)
                .then(function(result) {

                    //successful call
                    deferred.resolve(result.data);
                }, function() {
                    //error in call
                    deferred.reject();
                });

            return deferred.promise;


        }

        function saveExpenseTransaction(accountingTransaction) {
            var deferred = $q.defer();
            $http.post('api/AccountingFinancialController/SaveExpenseTransaction', accountingTransaction)
                .then(function(result) {
                    //successful call
                    deferred.resolve(result.data);
                }, function() {
                    //error in call
                    deferred.reject();
                });

            return deferred.promise;

        }

        function removeContributionCategoryData(contribution) {

            var deferred = $q.defer();


            $http({
                method: 'delete',
                url: '/api/AccountingFinancialController/DeleteFinancialContribution/',
                params: {
                    id: contribution.id
                }
            }).then(function(result) {
                _ContributionAccountData.splice(_ContributionAccountData.indexOf(contribution), 1);
                deferred.resolve(contribution);

            }, function(result) {

                deferred.reject(result);
            });

            return deferred.promise;
        }

        function InitializeAccountingModule() {
            var deferred = $q.defer();
            $http.get('api/AccountingFinancialController/InitializeAccountingModule')
                .then(function(result) {
                        //successful call
                        deferred.resolve(result.data);
                    },
                    function() {
                        //error in call
                        deferred.reject();
                    });

            return deferred.promise;
        }

        function IsAccountingModuleInitialized() {
            var deferred = $q.defer();

            $http.get('api/AccountingFinancialController/checkIfAccountDataTablesAreInitialized')
                .then(function(result) {
                        //successful call
                        _initBoolCheckAccountInitializedData = true;
                        deferred.resolve(result.data);
                    },
                    function() {
                        //error in call
                        deferred.reject();
                    });

            return deferred.promise;
        }

        function IsChartOfAccountDataInitialised() {
            return _initChartOfAccountData;

        }

        function IsBoolCheckAccountDataInitialised() {
            return _initBoolCheckAccountInitializedData;
        }

        function IsContributionAccountDataInitialised() {
            return _initContributionInitializedData;
        }

        //#region Internal Methods        

        //#endregion
    }
})();