﻿
(function () {
    'use strict';

    var controllerId = 'activitiesController';

    // TODO: replace app with your module name
    churchplusapp.controller(controllerId,
        ['$scope', '$window', 'cellFellowshipDataServices', 'notificationFactory', 'dataservices','$filter', 'ngTableParams', activitiesController]);

    function activitiesController($scope, $window, cellFellowshipDataServices, notificationFactory, dataservices, $filter, ngTableParams) {

        $scope.title = 'activitiesController';
        $scope.data = cellFellowshipDataServices.activities;

        // @ Check Initialization....
        if (cellFellowshipDataServices.isActivitiesDataInitialized() == false) {
            //@ Get Data
            cellFellowshipDataServices.getAllActivitiesData()
                .then(function () {
                    //@ Success  
                    ngTableFunction();
                },
         function () {
             //@ Failure
             notificationFactory.error('Error loading data...');
         });
        }
        else {
            ngTableFunction();
        }

        //function for calculating how people present
        $scope.Present = function (attendence) {
            var NoOfPeoplePresent = 0;
            for (var i = 0; attendence.length > i ; i++) {
                if (attendence[i].isPresent == true) {
                    NoOfPeoplePresent++;
                }
            }
            return NoOfPeoplePresent;
        }

        //Refresh Data
        $scope.Refresh = function () {
            cellFellowshipDataServices.getAllActivitiesData()
                .then(function () {
                    //@ Success
                    ngTableFunction();
                },
                function () {
                    //Error refreshing data set
                    notificationFactory.error('Can not retrive data from the server now, please check internet connections and try again');
                });
        }

        //Remove Data
        $scope.Remove = function (activityID) {
            if (confirm("Are you sure you want to delete this Activity Report")) {
                cellFellowshipDataServices.deleteActivityData(activityID)
                    .then(function (result) {
                        //@ Success

                        notificationFactory.success('activity successfully removed');
                    }, function (result) {
                        //@ Error

                        notificationFactory.error("Error occored while removing activity ");
                    });
            }
        }

        /////////////////////////////ng-table tins


        function ngTableFunction() {
            $scope.tableParams = new ngTableParams({
                page: 1,            // show first page
                count: 10,          // count per page
                sorting: {
                    name: 'asc'     // initial sorting
                }
            }, {
                total: $scope.data.length, // length of data
                getData: function ($defer, params) {
                    // use build-in angular filter
                    var orderedData = params.sorting() ? $filter('orderBy')($scope.data, params.orderBy()) : $scope.data;

                    $defer.resolve(orderedData.slice((params.page() - 1) * params.count(), params.page() * params.count()));
                }
            });

        }


        $scope.Goto = function (url) {
            $window.location = url;
        }
    }
})();
