﻿
(function () {
    'use strict';

    var controllerId = 'activitiesNewEditController';

    // TODO: replace app with your module name
    churchplusapp.controller(controllerId,
        ['$scope', '$window', '$routeParams', 'cellFellowshipDataServices', 'notificationFactory', '$filter', 'ngTableParams', activitiesNewEditController]);

    function activitiesNewEditController($scope, $window, $routeParams, cellFellowshipDataServices, notificationFactory, $filter, ngTableParams) {
        $scope.title = 'activitiesNewEditController';
        $scope.activity = {cellAttendances:[]};
        $scope.attendence = [];      

        if ($routeParams.id) {
            cellFellowshipDataServices.getSingleActivityData($routeParams.id)
             .then(function (result) {
                 //@ Success
                 $scope.activity = result;
                 bindCellCenters();
                 $scope.attendence = $scope.activity.cellAttendances;                 
                 ngTableFunction();
             },
             function () {
                 //Error refreshing data set
                 notificationFactory.error('Can not retrive data from the server now, please check internet connections and try again');
             });
        } else {
            bindCellCenters();

            $scope.$on('select2:change', function (event, element, incomingValue) {               
                cellFellowshipDataServices.getSingleHouseFellowshipData(incomingValue).then(
                   function (result) {
                       $scope.attendence = result.peopleInCenter;                       
                       ngTableFunction();
                   },
                   function () { });
            });            
            
        }


        /////////////////////////////ng-table for the members attendence


        function ngTableFunction() {
            $scope.tableParams = new ngTableParams({
                page: 1,            // show first page
                count: 10,          // count per page
                sorting: {
                    name: 'asc'     // initial sorting
                }
            }, {
                total: $scope.attendence.length, // length of data
                getData: function ($defer, params) {
                    // use build-in angular filter
                    var orderedData = params.sorting() ? $filter('orderBy')($scope.attendence, params.orderBy()) : $scope.attendence;
                    $defer.resolve(orderedData.slice((params.page() - 1) * params.count(), params.page() * params.count()));
                }
            });

        }


        ///////////////////// function for saving activity

        
        $scope.Save = function () {
            
            $scope.activity.cellCenterID = $('#cellCenterSelect').select2('data').id;            
            
            for (var i = 0; i < $scope.attendence.length; i++) {
                var anAttendence = {}
                //anAttendence.cellActivityID = $scope.activity.cellCenterID
                if ($scope.attendence[i].isPresent != true) {
                    anAttendence.isPresent = false;
                }
                else {
                    anAttendence.isPresent = $scope.attendence[i].isPresent;
                }
                
                anAttendence.person = $scope.attendence[i].person;
                anAttendence.personID = $scope.attendence[i].personID;
                
                if ($scope.attendence[i].cellActivityID != null)
                {
                    anAttendence.id = $scope.attendence[i].id;
                    anAttendence.cellActivityID = $scope.attendence[i].cellActivityID;
                    for (var j = 0; $scope.activity.cellAttendances.length > j; j++) {
                        if ($scope.activity.cellAttendances[j].id == anAttendence.id) {                            
                            $scope.activity.cellAttendances.splice(j, 1, anAttendence);
                            break;
                        }
                    }
                    
                }
                else
                {
                    $scope.activity.cellAttendances.push(anAttendence);
                }
                
            }
           
            cellFellowshipDataServices.saveActivityData($scope.activity)
                .then(function (result) {
                    //@ Success                    
                    $window.location = "#/HouseFellowshipActivities";
                }, function () {
                    //@ Failure
                    notificationFactory.error("Unsuccessful Operation");
                });
        }

        ///////////// function for cancel form input

        $scope.Cancel = function () {
            activity = {};
        }

        ///////////// select2 plugin for cellcenter form field

        function getCellCenters() {
            var options = [];
            cellFellowshipDataServices.getAllHouseFellowshipData().then(
                function () {
                    var data = cellFellowshipDataServices.houseFellowshipData;
                    for (var i = 0; i < data.length; i++) {
                        options.push({ id: data[i].id, text: data[i].address });
                    }
                },
                function () { })
            return options;
        }

        function bindCellCenters() {
            $('#cellCenterSelect')
                  .select2({
                      placeholder: 'Select House Fellowship',
                      multiple: false,
                      data: getCellCenters(),
                      width: "100%",
                      initSelection: function (element, callback) {
                          var returnCellCenter = $scope.activity.cellCenter;
                          //console.log($scope.activity.cellCenter);

                          if (returnCellCenter != null) {
                              callback({
                                  id: returnCellCenter.id,
                                  text: returnCellCenter.address
                              });

                          }
                      }
                  }).select2('val', []).on("change", function (e) {
                            // mostly used event, fired to the original element when the value changes
                          var returnValue = e.val;
                          $scope.$emit('select2:change', '#cellCenterSelect', returnValue);
                     });

        }


        /////////////// plugin for date field

        $(".datepicker").datepicker({
            showOtherMonths: true
        });

    }
})();
