﻿(function () {
    'use strict';

    var controllerId = 'announcementsController';

    // TODO: replace app with your module name
    churchplusapp.controller(controllerId, ['$scope', 'announcementdataservices', 'notificationFactory', 'dataservices','$filter','ngTableParams', announcementsController]);

    function announcementsController($scope, announcementdataservices, notificationFactory, dataservices, $filter,ngTableParams) {
        $scope.title = 'announcementsController';       

        $scope.data = announcementdataservices;

        //Load announcements
        if (announcementdataservices.IsannouncementDataInitialized() == false) {
            announcementdataservices.getannouncementsData().then(function () {
                //success         
                ngTableFunction();
            },
         function () {
             //failure
             alert('Something wrong just happened');
         });
        }
        else {
            ngTableFunction();
        }

        //////ng-table tins
        function ngTableFunction() {
            $scope.tableParams = new ngTableParams({
                page: 1,            // show first page
                count: 10,          // count per page
                sorting: {
                    name: 'asc'     // initial sorting
                }
            }, {
                total: $scope.data.announcements.length, // length of data
                getData: function ($defer, params) {
                    // use build-in angular filter
                    var orderedData = params.sorting() ?
                        $filter('orderBy')($scope.data.announcements, params.orderBy()) :
                        $scope.data.announcements;

                    $defer.resolve(orderedData.slice((params.page() - 1) * params.count(), params.page() * params.count()));
                }
            });

        }
        //refresh announcements
        $scope.Refresh = function () {          
            
            announcementdataservices.getannouncementsData().then(function () { },
                function () {
                    //Error refreshing data set
                    notificationFactory.error('Can not retrive data from the server now, please check internet connections and try again');
                });;

        }

       //remove announcement
        $scope.Remove = function (announcementID) {
            announcementdataservices.removeannouncementData(announcementID).then(function (a) {
                notificationFactory.success('Announcement removed');
            }, function (a) {
                notificationFactory.error(a);
            });

        }

        $scope.ConfirmDelete = function(announcementID) {
            if (confirm("Are you sure to want to Delete?") == true)
            {
                $scope.Remove(announcementID)
            }
            
                
        }

       

        $scope.activate = activate;

        function activate() {
            alert('loaded')
        }
        
    }
})();
