﻿churchplusapp.factory('AuthHttpResponseInterceptor', ['$http', '$q', AuthHttpResponseInterceptor]);

var AuthHttpResponseInterceptor = function ($q, $location) {
    //  toastr.options.positionClass = "toastr-bottom-right";

    return {
        response: function (response) {
            if (response.status === 401) {
                console.log("Response 401");
            }
            return response || $q.when(response);
        },
        responseError: function (rejection) {
            if (rejection.status === 401) {
                console.log("Response Error 401", rejection);
                $location.path('/Account/LogOn').search('returnUrl', $location.path());
            }
            return $q.reject(rejection);
        }
    }
};