﻿(function () {
    'use strict';

    var controllerId = 'campaignController';

    // TODO: replace app with your module name
    churchplusapp.controller(controllerId, ['$scope', '$filter', 'ngTableParams', 'campaignDataServices', 'notificationFactory', 'dataservices', campaignController]);

    function campaignController($scope, $filter, ngTableParams, campaignDataServices, notificationFactory, dataservices) {
        $scope.title = 'campaignController';

        $scope.campaigns = campaignDataServices.campaigns;

        //Load campaign Campaigns
        if (campaignDataServices.isCampaignDataInitialized() == false) {
            campaignDataServices.getCampaignsData().then(function () {
                //success 
                
                ngTableFunction();
            },
         function () {
             //failure
             alert('Something wrong just happened');
         });
        }
        else {
            ngTableFunction();
        }

        //////ng-table tins
        function ngTableFunction() {
            $scope.tableParams = new ngTableParams({
                page: 1,            // show first page
                count: 10,          // count per page
                sorting: {
                    name: 'asc'     // initial sorting
                }
            }, {
                total: $scope.campaigns.length, // length of data
                getData: function ($defer, params) {
                    // use build-in angular filter
                    var orderedData = params.sorting() ? $filter('orderBy')($scope.campaigns, params.orderBy()) : $scope.campaigns;

                    $defer.resolve(orderedData.slice((params.page() - 1) * params.count(), params.page() * params.count()));
                }
            });

        }

        $scope.Refresh = function () {
            campaignDataServices.getCampaignsData().then(function () {
            },
        function () {
            //failurenot
            notificationFactory.error('Can not retrive data from the server now, please check internet connections and try again');
        });

        }

        $scope.Remove = function (campaign) {
            if (confirm('You are about to delete Campaign')) {

                campaignDataServices.removeCampaignData(campaign).then(function (result) {
                    notificationFactory.success('Campaign removed');
                }, function (result) {
                    notificationFactory.error(result);
                });
            }
        }

        $scope.activate = activate;

        function activate() {
            alert('loaded')
        }


    }

})();