﻿(function () {
    'use strict';

    var serviceId = 'campaignDataServices';

    // TODO: replace app with your module name
    churchplusapp.factory(serviceId, ['$http', '$q', campaignDataServices]);

    function campaignDataServices($http, $q) {
        var _campaigns = [];
        var _members = [];
        var _initCampaigns = false;

        //////////////////////// Arrary for frequency

        var listOfFrequency = [{ id: 1, text: "Every Day" },
                                { id: 2, text: "Every 2 Days" },
                                { id: 3, text: "Every 3 Days" },
                                { id: 4, text: "Every 4 Days" },
                                { id: 5, text: "Every 5 Days" },
                                { id: 6, text: "Every 6 Days" },
                                { id: 7, text: "Every 7 Days" }];



        var service = {

            listOfFrequency: listOfFrequency,
            campaigns: _campaigns,
            getCampaignsData: getCampaignsData,
            addCampaignData: addCampaignData,
            removeCampaignData: removeCampaignData,
            isCampaignDataInitialized: isCampaignDataInitialized,
            getCampaignDataForEdit: getCampaignDataForEdit,
            removeCampaignMemberData: removeCampaignMemberData,
            removeCampaignMessageData: removeCampaignMessageData
        };

        return service;

        

        function getCampaignsData() {
            var deferred = $q.defer();

            $http.get('api/CampaignController/GetCampaigns').then(function (result) {
                //successful call
                angular.copy(result.data, _campaigns);
                _initCampaigns = true;

                deferred.resolve();
            },
            function () {
                //error in call
                deferred.reject();
            });
            return deferred.promise;
        }

        function addCampaignData(campaignData) {
            var deferred = $q.defer();
            if (campaignData.id != null) {

                for (var i = 0; i < _campaigns.length; i++) {

                    if (_campaigns[i].id == campaignData.id) {
                        _campaigns.splice(_campaigns.indexOf(_campaigns[i]), 1);

                    }
                }

            }

            $http.post('api/CampaignController/SaveCampaign', campaignData).then(function (result) {

                _campaigns.splice(0, 0, result.data);

                deferred.resolve(result.data);

            }, function () {
                //Error Function
                //put the entry back to the original state if there is error
                if (campaignData.id != null) {
                    _campaigns.splice(0, 0, campaignData);
                }

                deferred.reject();
            });

            return deferred.promise;
        }


        function removeCampaignData(campaignData) {
            var deferred = $q.defer();
            $http({
                method: 'delete',
                url: 'api/CampaignController/DeleteCampaign',
                params: { ID: campaignData.id }
            })
               .then(function (result) {
                   for (var i = 0; _campaigns.length > i; i++) {
                       if (_campaigns[i].id === campaignData.id) {
                           _campaigns.splice(_campaigns.indexOf(_campaigns[i]), 1);
                           break;
                       }

                   }
                   deferred.resolve(result.data);
               },
           function () {
               deferred.reject();
           });
            return deferred.promise;
        }


        function isCampaignDataInitialized() {
            return _initCampaigns;
        }

        function getCampaignDataForEdit(id) {
            var deferred = $q.defer();

            $http({
                method: 'get',
                url: 'api/CampaignController/GetCampaign',
                params: { id: id }
            }).then(function (result) {
                //successful call

                deferred.resolve(result.data);
            },
            function () {
                //error in call
                deferred.reject();
            });
            return deferred.promise;
        }

        function removeCampaignMemberData(campaignMemberData) {

            var deferred = $q.defer();
            $http({
                method: 'delete',
                url: 'api/CampaignController/DeletePeopleInCampaign',
                params: { id: campaignMemberData.id }
            }).then(function (result) {
                deferred.resolve(result.data);

            }, function (result) {

                deferred.reject(result.data);
            });

            return deferred.promise;
        }

        function removeCampaignMessageData(campaignMessageData) {

            var deferred = $q.defer();
            $http({
                method: 'delete',
                url: 'api/CampaignController/DeleteCampaignMessage',
                params: { id: campaignMessageData.id }
            }).then(function (result) {
                deferred.resolve(result.data);

            }, function (result) {

                deferred.reject(result.data);
            });

            return deferred.promise;
        }
    }

})();
