﻿(function () {
    'use strict';

    var controllerId = 'campaignNewEditController';

    // TODO: replace app with your module name
    churchplusapp.controller(controllerId, ['$scope','$window', '$routeParams', 'dataservices','campaignDataServices','notificationFactory', campaignNewEditController]);

    function campaignNewEditController($scope, $window, $routeParams, dataservices, campaignDataServices, notificationFactory) {
        $scope.title = 'campaignNewEditController';

        $scope.campaign = { campaignMessages: [], peopleInCampaign: [] };

        
       
        ///////////////////////initializing the form

        if ($routeParams.id == null) {
            bindSelectFrequency();
            
        }
        else {
            campaignDataServices.getCampaignDataForEdit($routeParams.id).then(function (campaign) {                
                $scope.campaign = campaign;
                bindSelectFrequency();
            }, function () {
                //Use Toaster Alert Note
                notificationFactory.error("Getting the campaign Information, try again");

            })
        }

        /////////////////////////function for saving campaign

        $scope.Save = function () {
            $scope.campaign.frequency = $('#select-frequency').select2('data').id;
            campaignDataServices.addCampaignData($scope.campaign).then(function (result) {
                $window.location = "#/Campaigns"
            }, function () {
                notificationFactory.error("Unsuccessful Operation");

            });
        }

        /////////////////////////////function for cancel form content

        $scope.Cancel = function () {
            $scope.campaign = {};
        }


        ///////////////////////////function for deleting a person from the campaign people

        $scope.removePerson = function (person) {
            if (person.id == null) {
                $scope.campaign.peopleInCampaign.splice($scope.campaign.peopleInCampaign.indexOf(person), 1);
                notificationFactory.success();
            } else {
                campaignDataServices.removeCampaignMemberData(person).then(function (r) {
                    $scope.campaign.peopleInCampaign.splice($scope.campaign.peopleInCampaign.indexOf(person), 1);
                    notificationFactory.success();
                }, function (r) {
                    notificationFactory.error(r);
                });
            }
        }


        ///////////////////////////function for deleting a message from the campaign messages

        $scope.removeMessage = function (message) {
            if (message.id == null) {
                $scope.campaign.campaignMessages.splice($scope.campaign.campaignMessages.indexOf(message), 1);
                notificationFactory.success();
            } else {
                campaignDataServices.removeCampaignMessageData(message).then(function (r) {
                    $scope.campaign.campaignMessages.splice($scope.campaign.campaignMessages.indexOf(message), 1);
                    notificationFactory.success("Message removed");
                }, function (r) {
                    notificationFactory.error(r);
                });
            }
        }

        ////////////////////////function for adding email message to the campaign messages

        $scope.AddEmailMessage = function () {
            var EmailMessage = {};
            EmailMessage.sequenceDay = $('#sequenceDaySelectEmail').select2('data').id;
            EmailMessage.time = $('#spinner-time-Email').val();
            EmailMessage.subject = $scope.emailSubject;
            EmailMessage.message = $('.editor').val();
            EmailMessage.messageType = 1;

            if ($scope.emailID == null) {
                $scope.campaign.campaignMessages.splice(0, 0, EmailMessage);
            }
            else {
                EmailMessage.id = $scope.emailID;

                for (var i = 0; i < $scope.campaign.campaignMessages.length; i++) {
                    if ($scope.campaign.campaignMessages[i].id == EmailMessage.id) {
                        $scope.campaign.campaignMessages.splice($scope.campaign.campaignMessages.indexOf($scope.campaign.campaignMessages[i]), 1, EmailMessage);
                        // console.log("found");
                    }
                }
            }

            $('#sequenceDaySelectEmail').select2("val", "");
            $('#spinner-time-Email').val("");
            $scope.emailSubject = "";
            $('.editor').val("");
        }

        ////////////////////////function for adding email message to the campaign messages

        $scope.AddSMSMessage = function () {
            var SMSMessage = {};
            SMSMessage.sequenceDay = $('#sequenceDaySelectSMS').select2('data').id;
            SMSMessage.time = $('#spinner-time-SMS').val();
            SMSMessage.subject = $scope.SMSSubject;
            SMSMessage.message = $scope.SMSBody;
            SMSMessage.messageType = 0;
           
            if ($scope.SMSID == null) {
                
                $scope.campaign.campaignMessages.splice(0, 0, SMSMessage);
            }
            else {
                
                SMSMessage.id = $scope.SMSID;                

                for (var i = 0; i < $scope.campaign.campaignMessages.length; i++) {
                    if ($scope.campaign.campaignMessages[i].id == SMSMessage.id) {
                        $scope.campaign.campaignMessages.splice($scope.campaign.campaignMessages.indexOf($scope.campaign.campaignMessages[i]), 1, SMSMessage);
                       // console.log("found");
                    }
                }
            }
            
            
            $('#sequenceDaySelectSMS').select2("val", "");
            $('#spinner-time-SMS').val("");
            $scope.SMSSubject = "";
            $scope.SMSBody = "";
        }


        ///////////////////////// select2 plugin for the frequency field in the form

        function bindSelectFrequency() {
            $('#select-frequency')
                  .select2({
                      placeholder: 'Select Frequency',
                      multiple: false,                      
                      data: campaignDataServices.listOfFrequency,
                      width: "100%",
                      initSelection: function (element, callback) {
                          var returnFrequency = $scope.campaign.frequency;
                          var frequencyText;

                          if (returnFrequency != null) {

                              for (var i = 0; campaignDataServices.listOfFrequency.length > i; i++) {
                                  if (campaignDataServices.listOfFrequency[i].id == returnFrequency) {
                                      frequencyText = campaignDataServices.listOfFrequency[i].text;
                                      break;
                                  }
                              }

                              callback({
                                  id: returnFrequency,
                                  text: frequencyText
                              });

                          }
                      }
                  }).select2('val', []);
        }

        ////////////////// function for restricting the subject of sms message to 11 xters

        $scope.restrictInput = function () {

            var value = $scope.SMSSubject;
            if (value != null && value.length > 9) {
                var restrict = value.trim().substring(0, 10);
                $scope.SMSSubject = restrict;
            }
        }

        ////////////////// select2 plugin for sequence day in the form for sms and email

       
        $('#sequenceDaySelectEmail').select2({});
       
        $('#sequenceDaySelectSMS').select2({});

        /////////////////spinner plugin for time field in the form for sms and email 

        $("#spinner-time-SMS").timespinner();
        $("#spinner-time-Email").timespinner();

        /////////////editor plugin
        $('.editor').wysihtml5({
            stylesheets: "css/wysihtml5/wysiwyg-color.css"
        });

        ///////////////
        $('#PersonSelect').select2({
            placeholder: 'Select member',
            multiple: true,
            minimumInputLength: 3,
            query: function (query) {
                dataservices.getPersonSearch(query.term).then(function (data) {

                    query.callback({ results: data });

                    // return data;
                }, function () { });
            },
            width: "100%"
        });

        $scope.AddPersonToCampaign = function () {

            var selectMembersID = $('#PersonSelect').val();

            dataservices.getPeopleInformation(selectMembersID).then(function (result) {

                $.each(result, function (i, person) {

                    var PersonForCampaign = {};
                    PersonForCampaign.person = person;
                    PersonForCampaign.personID = person.id;
                    PersonForCampaign.currentStatus = "Just Added";
                    PersonForCampaign.numberOfMessagesSent = 0;
                    PersonForCampaign.dateEntered = new Date();

                    $scope.campaign.peopleInCampaign.splice(0, 0, PersonForCampaign);

                    $('#PersonSelect').val('');

                })
            }, function () {
                notificationFactory.error("Unsuccessful Operation");

            });
        }

        $scope.editMessage = function (message) {
            //alert(message.subject);
            if (message.messageType == 0) {               
               
                $scope.SMSSubject = message.subject;
                $scope.SMSBody = message.message;
                $('#sequenceDaySelectSMS').select2("val", message.sequenceDay);
                $('#spinner-time-SMS').val(message.time);
                $scope.SMSID = message.id;                
                
                $("#NewSMSMessage_modal").modal("show");
               
            }
            else if (message.messageType == 1) {

                $scope.emailSubject = message.subject;
                $('#sequenceDaySelectEmail').select2("val", message.sequenceDay);
                $('#spinner-time-Email').val(message.time);
                $('.editor').val(message.message);                
                $scope.emailID = message.id;

                $("#NewEmailMessage_modal").modal("show");
            }
            
        }
    }
})();