﻿(function () {
    'use strict';

    var serviceId = 'cellFellowshipDataServices';

    // TODO: replace app with your module name
    churchplusapp.factory(serviceId, ['$http', '$q', cellFellowshipDataServices]);

    function cellFellowshipDataServices($http, $q) {
        // Define the functions and properties to reveal.

        //// HOUSE FELLOWSHIP VARIEBLES
        var _houseFellowshipData = [];
        var _initHouseFellowshipData = false;
        var _inithouseFellowshipActivityData = false;
        //// ZONE VARIEBLES
        var _zoneData = [];
        var _initZoneData = false;

        //// ACTIVITY VARIABLES
        var _activities = [];
        var _initActivityData = false;



        var service = {

            /// FELLOWSHIP SERVICES
            houseFellowshipData: _houseFellowshipData,
            getAllHouseFellowshipData: getAllHouseFellowshipData,
            getHouseFellowshipsForZone: getHouseFellowshipsForZone,
            getSingleHouseFellowshipData: getSingleHouseFellowshipData,
            getHouseFellowshipsBelongedByAMember:getHouseFellowshipsBelongedByAMember,
            saveHouseFellowshipData: saveHouseFellowshipData,
            deleteHouseFellowshipData: deleteHouseFellowshipData,
            isHouseFellowshipDataInitialized: isHouseFellowshipDataInitialized,
            removeHouseFellowshipMemberData: removeHouseFellowshipMemberData,


            /// ZONE SERVICES
            zoneData: _zoneData,
            getAllZoneData: getAllZoneData,
            getSingleZoneData: getSingleZoneData,
            saveZoneData: saveZoneData,
            deleteZoneData: deleteZoneData,
            isZoneDataInitialized: isZoneDataInitialized,

            /// ACTIVITY SERVICES
            activities: _activities,
            getAllActivitiesData: getAllActivitiesData,
            getAllActivityByHouseFellowship: getAllActivityByHouseFellowship,
            getSingleActivityData: getSingleActivityData,
            saveActivityData: saveActivityData,
            deleteActivityData: deleteActivityData,
            isActivitiesDataInitialized: isActivitiesDataInitialized,
            isHouseFellowshipActivityDataInitialized: isHouseFellowshipActivityDataInitialized
        };

        return service;

        /////////////////// FOR FELLOWSHIP //////////////////

        //Get All Data.
        function getAllHouseFellowshipData() {
            var deferred = $q.defer();
            $http.get("api/HouseFellowshipController/GetHouseFellowshipData")
                .then(function (result) {
                    //successful call
                    angular.copy(result.data, _houseFellowshipData);
                    _initHouseFellowshipData = true;

                    deferred.resolve();
                },
            function () {
                //error in call
                deferred.reject();
            });
            return deferred.promise;
        }

       

        //Get Single Data.
        function getSingleHouseFellowshipData(fellowshipID) {
            var deferred = $q.defer();
            $http({
                method: 'get',
                url: 'api/HouseFellowshipController/GetSingleHouseFellowshipData',
                params: { id: fellowshipID }
            }).then(function (result) {
                //successful call
                deferred.resolve(result.data);
            },
            function () {
                //error in call
                deferred.reject();
            });
            return deferred.promise;
        }

        //Save Data.
        function saveHouseFellowshipData(fellowship) {
            var deferred = $q.defer();


            $http.post('api/HouseFellowshipController/SaveHouseFellowshipData', fellowship)
                .then(function (result) {

                    if (fellowship.id != null) {

                        for (var i = 0; _houseFellowshipData.length > i; i++) {
                            if (_houseFellowshipData[i].id === result.data.id) {
                                _houseFellowshipData.splice(i, 1, result.data);
                                break;
                            }
                        }

                    } else
                        _houseFellowshipData.splice(0, 0, result.data);

[i]

                    deferred.resolve(result.data);

                }, function (result) {

                    deferred.reject(result.data);
                });

            return deferred.promise;

        }

        //Delete Single Data.
        function deleteHouseFellowshipData(fellowshipID) {
            var deferred = $q.defer();

            $http({
                method: 'delete',
                url: 'api/HouseFellowshipController/DeleteHouseFellowshipData',
                params: { id: fellowshipID }
            })
                .then(function (result) {

                    //remove the deleted item from the local dataset
                    for (var i = 0; _houseFellowshipData.length > i; i++) {

                        if (_houseFellowshipData[i].id === result.data.id) {

                            _houseFellowshipData.splice(i, 1);
                            break;
                        }
                    }
                    deferred.resolve(result.data);

                }, function (result) {

                    deferred.reject(result.data);
                });

            return deferred.promise;
        }

        // Initialization check...
        function isHouseFellowshipDataInitialized() {
            return _initHouseFellowshipData;
        }

        // get all housefellowships for a zone
        function getHouseFellowshipsForZone(zoneID) {
            var deferred = $q.defer();
            $http({
                method: 'get',
                url: 'api/HouseFellowshipController/GetHouseFellowshipsForZone',
                params: { zoneID: zoneID }
            }).then(function (result) {
                //successful call
                deferred.resolve(result.data);
            },
            function () {
                //error in call
                deferred.reject();
            });
            return deferred.promise;
        }

        // function for remove a member from housefellowship
        function removeHouseFellowshipMemberData(member) {
            var deferred = $q.defer();
            $http({
                method: 'delete',
                url: 'api/HouseFellowshipController/DeleteHouseFellowshipMember',
                params: { PersonInHouseFellowshipID: member.id }
            }).then(function (result) {
                deferred.resolve(result.data);
            }, function (result) {

                deferred.reject(result.data);
            });

            return deferred.promise;
        }
        /////////////////// FOR ZONES //////////////////

        //Get All Data.
        function getAllZoneData() {

            var deferred = $q.defer();
            if (_initZoneData == false) {
                $http.get("api/ZoneFellowshipController/GetZoneFellowshipData")
                    .then(function (result) {
                        //successful call
                        angular.copy(result.data, _zoneData);
                        _initZoneData = true;

                        deferred.resolve();
                    },
                function () {
                    //error in call
                    deferred.reject();
                });
            } else {
                deferred.resolve();

            }
            return deferred.promise;
        }

        //Get Singele Data.
        function getSingleZoneData(zoneID) {
            var deferred = $q.defer();
            $http({
                method: 'get',
                url: 'api/ZoneFellowshipController/GetSingleZoneFellowshipData',
                params: { id: zoneID }
            }).then(function (result) {
                //successful call
                deferred.resolve(result.data);
            },
            function () {
                //error in call
                deferred.reject();
            });
            return deferred.promise;
        }

        //Save Data.
        function saveZoneData(zone) {

            var deferred = $q.defer();

            $http.post('api/ZoneFellowshipController/SaveHouseFellowshipData', zone)
                .then(function (result) {

                    if (zone.id != null) {

                        for (var i = 0; _zoneData.length > i; i++) {
                            if (_zoneData[i].id === result.data.id) {
                                _zoneData.splice(i, 1, result.data);
                                break;
                            }
                        }

                    } else 
                        _zoneData.splice(0, 0, result.data);
                    

                    deferred.resolve(result.data);

                }, function (result) {

                    deferred.reject(result.data);
                });

            return deferred.promise;

        }

        //Delete Single Data.
        function deleteZoneData(zoneID) {
            var deferred = $q.defer();
            $http({
                method: 'delete',
                url: 'api/ZoneFellowshipController/DeleteZoneFellowshipData',
                params: { id: zoneID }
            })
                .then(function (result) {

                    //remove the deleted item from the local dataset

                    for (var i = 0; _zoneData.length > i; i++) {

                        if (_zoneData[i].id == result.data.id) {
                            _zoneData.splice(i, 1);
                            break;
                        }
                    }
                    deferred.resolve(result.data);

                }, function (result) {
                    // At Error
                    deferred.reject(result.data);
                });

            return deferred.promise;
        }

        // Initialization check...
        function isZoneDataInitialized() {
            return _initZoneData;
        }



        //////////////////////// Activity ////////////////////

        //Get All Data.
        function getAllActivitiesData() {

            var deferred = $q.defer();
            if (_initActivityData == false) {
                $http.get("api/HouseFellowshipController/GetHouseFellowshipActivities")
                    .then(function (result) {
                        //successful call
                        angular.copy(result.data, _activities);
                        _initActivityData = true;

                        deferred.resolve();
                    },
                function () {
                    //error in call
                    deferred.reject();
                });
            } 
            return deferred.promise;
        }

        /// get all activity by housefellowship
        function getAllActivityByHouseFellowship(houseFellowshipID) {
            var deferred = $q.defer();
            $http({
                method: 'get',
                url: "api/HouseFellowshipController/GetActivitiesForHouseFellowship",
                params: {houseFellowshipID: houseFellowshipID }
            }).then(function (result) {
                //successful call
                deferred.resolve(result.data);
            },
            function () {
                //error in call
                deferred.reject();
            });
            return deferred.promise;
        }

        //Get Singele Data.
        function getSingleActivityData(activityID) {
            var deferred = $q.defer();
            $http({
                method: 'get',
                url: 'api/HouseFellowshipController/GetHouseFellowshipActivityByID',
                params: { houseFellowshipActivityID: activityID }
            }).then(function (result) {
                //successful call
                deferred.resolve(result.data);
            },
            function () {
                //error in call
                deferred.reject();
            });
            return deferred.promise;
        }

        //Save Data.
        function saveActivityData(activity) {

            var deferred = $q.defer();            

            $http.post('api/HouseFellowshipController/SaveHouseFellowshipActivity', activity)
                .then(function (result) {

                    if (activity.id != null) {
                        
                        for (var i = 0; _activities.length > i; i++) {
                            if (_activities[i].id == activity.id) {
                                _activities.splice(_activities.indexOf(_activities[i]), 1, result.data);
                                break;
                            }
                        }

                    }
                    else {
                        _activities.splice(0, 0, result.data);
                    }
                    
                    deferred.resolve(result.data);

                }, function (result) {
                    //Error Function
                    //put the entry back to the original state if there is error
                    if (activity.id != null) {
                        _activities.splice(0, 0, activity);
                    }

                    deferred.reject(result);
                });

            return deferred.promise;
        }

        //Delete Single Data.
        function deleteActivityData(activityID) {
            var deferred = $q.defer();
            $http({
                method: 'delete',
                url: 'api/HouseFellowshipController/DeleteHouseFellowshipActivity',
                params: {houseFellowshipActivityID: activityID }
            })
                .then(function (result) {

                    //remove the deleted item from the local dataset

                    for (var i = 0; _activities.length > i; i++) {

                        if (_activities[i].id == result.data.id) {
                            _activities.splice(i, 1);
                            break;
                        }
                    }
                    deferred.resolve(result.data);

                }, function (result) {
                    // At Error
                    deferred.reject(result.data);
                });

            return deferred.promise;
        }

        function getHouseFellowshipsBelongedByAMember(id) {

            var deferred = $q.defer();
            $http({
                method: 'get',
                url: ' api/HouseFellowshipController/GetHouseFellowshipBelongToByMember',
                params: { id: id }
            }).then(function (result) {
                //successful call

                deferred.resolve(result.data);
            },
            function () {
                //error in call
                deferred.reject();
            });
            return deferred.promise;
        }

        // Initialization check...
        function isActivitiesDataInitialized() {
            return _initActivityData;
        }
        // Initialization check...
        function isHouseFellowshipActivityDataInitialized() {
            return _inithouseFellowshipActivityData;
        }
        ///////////////////////////////

        function getActivitiesDataForSingleHouseFellowship(dataID) {
            var deferred = $q.defer();
            if (_initActivitiesForSingleHouseFellowshipData == false) {
                $http({
                    method: 'get',
                    url: 'api/HouseFellowshipController/GetActivitiesForHouseFellowship',
                    params: {
                        houseFellowshipID: dataID
                    }
                })
				.then(function (result) {
				    //successful call
				    angular.copy(result.data, _activitiesForSingleHouseFellowshipData);
				    _initActivitiesForSingleHouseFellowshipData = true;
				    deferred.resolve(result.data);
				},
					function () {
					    //error in call
					    deferred.reject();
					});
            } else {
                deferred.resolve();
            }
            return deferred.promise;
        }


        function getHouseFellowshipsBelongedByAMember(id) {

            var deferred = $q.defer();
            $http({
                method: 'get',
                url: ' api/HouseFellowshipController/GetHouseFellowshipBelongToByMember',
                params: { id: id }
            }).then(function (result) {
                //successful call

                deferred.resolve(result.data);
            },
            function () {
                //error in call
                deferred.reject();
            });
            return deferred.promise;
        }
        // Initialization check...
        function isActivitiesForSingleHouseFellowshipDataInitialized() {
            return _initActivitiesForSingleHouseFellowshipData;
        }

    }
})();


/*
// APIs
===========================================================

"api/HouseFellowshipController/GetHouseFellowshipData"
"api/HouseFellowshipController/GetSingleHouseFellowshipData"
"api/HouseFellowshipController/SaveHouseFellowshipData"
"api/HouseFellowshipController/DeleteHouseFellowshipData"

"api/ZoneFellowshipController/GetZoneFellowshipData"
"api/ZoneFellowshipController/GetSingleZoneFellowshipData"
"api/ZoneFellowshipController/SaveHouseFellowshipData"
"api/ZoneFellowshipController/DeleteZoneFellowshipData"

*/