﻿(function () {
    'use strict';

    var serviceId = 'churchProfileDataServices';

    churchplusapp.factory(serviceId, ['$http', '$q', churchProfileDataServices]);

    function churchProfileDataServices($http, $q) {

        var _churchProfile = {};

        var _initChurchProfile = false;


        var service = {
            churchProfile: _churchProfile,
            getCountriesData: getCountriesData,
            getChurchProfileData: getChurchProfileData,
            addChurchProfileData: addChurchProfileData,            
            isChurchProfileDataInitialized: isChurchProfileDataInitialized           
        };

        return service;

        function getCountriesData() {
            var deferred = $q.defer();

            $http.get('api/LookUpController/getCountries').then(function (result) {
                //successful call

                deferred.resolve(result.data);
            },
            function () {
                //error in call
                deferred.reject();
            });
            return deferred.promise;
        }

        function isChurchProfileDataInitialized() {
            return _initChurchProfile;
        }

        function getChurchProfileData() {
            var deferred = $q.defer();

            $http.get('api/churchprofileController/getChurchInfo').then(function (result) {
                //successful call
                angular.copy(result.data, _churchProfile);
                _initChurchProfile = true;

                deferred.resolve(result.data);
            },
            function () {
                //error in call
                deferred.reject();
            });
            return deferred.promise;
        }

        function addChurchProfileData(churchProfileData) {
            var deferred = $q.defer();
            
            $http.post('api/churchprofileController/saveChurchInfo', churchProfileData).then(function (result) {
               
                _churchProfile = result.data;
                //angular.copy(result.data, _churchProfile);
                deferred.resolve(result.data);

            }, function (result) {

                deferred.reject(result.data);
            });

            return deferred.promise;

        }

       
    }
})();