﻿(function () {
    'use strict';
    var controllerId = 'churchProfileNewEditController';
   
    churchplusapp.controller(controllerId, ['$scope', '$window', 'notificationFactory', 'churchProfileDataServices', '$upload', churchProfileNewEditController]);


    function churchProfileNewEditController($scope, $window, notificationFactory, churchProfileDataServices, $upload) {
       
        $scope.title = 'churchProfileNewEditController';

        $scope.profileData = churchProfileDataServices.churchProfile;

        $scope.selectedFile;

        if (churchProfileDataServices.isChurchProfileDataInitialized() == false) {
            churchProfileDataServices.getChurchProfileData().then(
                function () {
                   $('#timezoneSelect').select2({});
                    $('#timezoneSelect').select2('val',$scope.profileData.timeZone);
                    bindCountrySelect()
                },
                function () {
                    //failure
                });
        }

        $scope.onFileSelect = function ($files) {
            $scope.selectedFile = $files[0];
        };

        function SaveData() {
            $scope.profileData.countryID = $('#countrySelect').select2('data').id;
            $scope.profileData.timeZone = $('#timezoneSelect').select2('data').id;
            churchProfileDataServices.addChurchProfileData($scope.profileData).then(function (result) {
                notificationFactory.success("Successful Operation");

            },
                function () {
                    notificationFactory.error("Unsuccessful Operation");
                });
        }

        $scope.Save = function () {       

            if ($scope.profileData != null) {

                if ($scope.selectedFile) {
                    $scope.upload = $upload.upload({

                        url: 'api/ImageUploadController/saveChurchPix',
                        method: "POST",
                        file: $scope.selectedFile

                    }).success(function (data, status, headers, config) {
                        var logo = data.replace(data[0], ' ').replace(data[data.length - 1], ' ');
                      //  console.log(logo);
                        $scope.profileData.logo = logo
                        SaveData();
                    });

                }
                else {
                    SaveData();
                }
            }
            
        }
        
        //// select2 plugin for the time zone field

        //$('#timezoneSelect').select2({});


        //// select2 plugin for countries field

        function getCountries(){
            var options = [];
            churchProfileDataServices.getCountriesData().then(
                function (result) {
                    angular.copy(result, options)
                    //options = result.data;
                },
                function () { });
            return options;
        }
        
        function bindCountrySelect() {
            $('#countrySelect').select2({
                placeholder: 'Select Country',
                multiple: false,
                data: getCountries(),
                width: "100%",
                initSelection: function (element, callback) {
                    var returnCountry = $scope.profileData.country;
                    console.log($scope.profileData.country);
                    if (returnCountry != null) {
                        callback({
                            id: returnCountry.id,
                            text: returnCountry.name
                        });

                    }
                }
            }).select2('val', []);
        }

       

       

        $scope.Cancel = function () {
            $scope.profileData = {};
        }
    }



   

})();
