/// <reference path="reports/view/Performance/servicePerformanceView.html" />
/// <reference path="reports/view/Membership/AllMembershipView.html" />
/// <reference path="reports/view/Membership/AllMembershipView.html" />
/// <reference path="reports/view/Membership/AllMembershipView.html" />
/// <reference path="../Scripts/js/angular.min.js" />
var churchplusapp = angular.module('churchplusapp', ['ngRoute', 'ngAnimate', 'angular-loading-bar', 'ngTable', 'angulartics', 'angulartics.google.analytics', 'angularFileUpload', 'ngSanitize'])
    .config(function($routeProvider, $analyticsProvider) {
        $routeProvider
            .when('/', {
                controller: 'homedashboardcontroller',
                templateUrl: 'churchplusapp/dashboard/view/homedashboard.html'
            })
            .when('/Groups', {
                controller: 'groupscontroller',
                templateUrl: 'churchplusapp/groups/view/groupsHomeView.html'
            })
            .when('/EditGroup/:id', {
                controller: 'groupNewEditController',
                templateUrl: 'churchplusapp/groups/view/groupNewEdit.html'
            })
            .when('/AddGroup', {
                controller: 'groupNewEditController',
                templateUrl: 'churchplusapp/groups/view/groupNewEdit.html'
            })

        //Membership Routes
        .when('/Membership/All', {
            controller: 'membershipcontroller',
            templateUrl: 'churchplusapp/membership/view/people.html'
        }).when('/Membership/Member', {
            controller: 'memberEditNewController',
            templateUrl: 'churchplusapp/membership/view/personaddedit.html'
        }).when('/Membership/Member/:id', {
            controller: 'memberEditNewController',
            templateUrl: 'churchplusapp/membership/view/personaddedit.html'
        }).when('/Membershipdashboard', {
            controller: 'membershipdashboardcontroller',
            templateUrl: 'churchplusapp/dashboard/view/membershipdashboard.html'
        }).when('/Membership/Members', {
            controller: 'membersController',
            templateUrl: 'churchplusapp/membership/view/members.html'
        })

        //first timers
        .when('/Membership/FirstTimers', {
            controller: 'firsttimercontroller',
            templateUrl: 'churchplusapp/membership/view/firsttimers.html'
        }).when('/Membership/FirstTimer:id', {
            controller: 'firsttimercontroller',
            templateUrl: 'churchplusapp/membership/view/firstTimerNewEdit.html'
        }).when('/Membership/AddFirsttimer', {
            controller: 'firsttimercontroller',
            templateUrl: 'churchplusapp/membership/view/firstTimerNewEdit.html'
        }).when('/Firsttimersdashboard', {
            controller: 'firsttimercontroller',
            templateUrl: 'churchplusapp/dashboard/view/firstTimerDashBoard.html'
        }) //new converts
        .when('/Membership/NewConverts', {
            controller: 'newConvertController',
            templateUrl: 'churchplusapp/membership/view/newconverts.html'
        }).when('/Newconvert:id', {
            controller: 'newconvertcontroller',
            templateUrl: 'churchplusapp/membership/view/newconvertNewEdit.html'
        }).when('/Addnewconvert', {
            controller: 'newconvertcontroller',
            templateUrl: 'churchplusapp/membership/view/newconvertNewEdit.html'
        }).when('/NewconvertDashboard', {
            controller: 'newconvertdashboard',
            templateUrl: 'churchplusapp/dashboard/view/newconvertsDashboard.html'
        }) //families
        .when('/Families', {
            controller: 'familycontroller',
            templateUrl: 'churchplusapp/membership/view/familiesHomeView.html'
        }).when('/Newfamily', {
            controller: 'familycontroller',
            templateUrl: 'churchplusapp/membership/view/familyNewEdit.html'
        }).when('/Newfamily:id', {
            controller: 'familycontroller',
            templateUrl: 'churchplusapp/membership/view/familyNewEdit.html'
        }) //Church Operations Routes
        //Events
        .when('/Events/All', {
            controller: 'eventsController',
            templateUrl: 'churchplusapp/events/view/eventsHomeView.html'
        }).when('/Events/NewEvent', {
            controller: 'eventNewEditController',
            templateUrl: 'churchplusapp/events/view/eventNewEditView.html'
        }).when('/Events/Event/:id', {
            controller: 'eventNewEditController',
            templateUrl: 'churchplusapp/events/view/eventNewEditView.html'
        }).when('/Events/EventReports', {
            controller: 'eventsReportController',
            templateUrl: 'churchplusapp/events/view/eventsReportsHomeView.html'
        }).when('/Events/NewEventReport', {
            controller: 'eventReportNewEditController',
            templateUrl: 'churchplusapp/events/view/eventReportNewEditView.html'
        }).when('/Events/EventReport/:id', {
            controller: 'eventReportNewEditController',
            templateUrl: 'churchplusapp/events/view/eventReportNewEditView.html'
        })

        //routes for announcements pages by victoria
        .when('/Announcements', {
            controller: 'announcementsController',
            templateUrl: 'churchplusapp/announcement/view/announcementHomeView.html'
        }).otherwise({
            redirectTo: "/"
        })
            .when('/Announcements/NewAnnouncement', {
                controller: 'announcementsNewEditController',
                templateUrl: 'churchplusapp/announcement/view/announcementNewEditView.html'
            }).otherwise({
                redirectTo: "/"
            })
            .when('/Announcements/NewAnnouncement/:id', {
                controller: 'announcementsNewEditController',
                templateUrl: 'churchplusapp/announcement/view/announcementNewEditView.html'
            }).otherwise({
                redirectTo: "/"
            })

        //end of routes for announcements pages


        //routes for testimonies pages by victoria
        .when('/Testimonies', {
            controller: 'testimoniesController',
            templateUrl: 'churchplusapp/testimonies/view/testimoniesHomeView.html'
        })
            .when('/Testimonies/NewTestimony', {
                controller: 'testimoniesNewEditController',
                templateUrl: 'churchplusapp/testimonies/view/testimoniesNewEditView.html'
            })
            .when('/Testimonies/NewTestimony/:id', {
                controller: 'testimoniesNewEditController',
                templateUrl: 'churchplusapp/testimonies/view/testimoniesNewEditView.html'
            }).otherwise({
                redirectTo: "/"
            })

        //===== FOR HOUSE FELLOWSHIPS >>>>>>>
        .when('/HouseFellowship', {
            controller: 'houseFellowshipsController',
            templateUrl: 'churchplusapp/cellfellowship/view/houseFellowshipHomeView.html'
        })
            .when('/HouseFellowship/NewHouseFellowship', {
                controller: 'houseFellowshipNewEditController',
                templateUrl: 'churchplusapp/cellfellowship/view/houseFellowshipNewEditView.html'
            })
            .when('/HouseFellowship/NewHouseFellowship/:id', {
                controller: 'houseFellowshipNewEditController',
                templateUrl: 'churchplusapp/cellfellowship/view/houseFellowshipNewEditView.html'
            })
            .when('/HouseFellowshipActivities', {
                controller: 'activitiesController',
                templateUrl: 'churchplusapp/cellfellowship/view/houseFellowshipActivityHomeView.html'
            })
            .when('/HouseFellowshipActivities/NewActivity', {
                controller: 'activitiesNewEditController',
                templateUrl: 'churchplusapp/cellfellowship/view/houseFellowshipActivityNewEditView.html'
            })
            .when('/HouseFellowshipActivities/EditActivity/:id', {
                controller: 'activitiesNewEditController',
                templateUrl: 'churchplusapp/cellfellowship/view/houseFellowshipActivityNewEditView.html'
            })
            .when('/HouseFellowshipDashboard', {
                controller: 'housefellowshipdashboardcontroller',
                templateUrl: 'churchplusapp/dashboard/view/housefellowshipDashboard.html'
            }).otherwise({
                redirectTo: "/"
            })

        //===== FOR ZONES>>>>>>>
        .when('/Zone', {
            controller: 'zonesHomeController',
            templateUrl: 'churchplusapp/cellfellowship/view/zoneHomeView.html'
        })
            .when('/Zone/NewZone', {
                controller: 'zoneNewEditController',
                templateUrl: 'churchplusapp/cellfellowship/view/zoneNewEditView.html'
            })
            .when('/Zone/NewZone/:id', {
                controller: 'zoneNewEditController',
                templateUrl: 'churchplusapp/cellfellowship/view/zoneNewEditView.html'
            })
            .otherwise({
                redirectTo: "/"
            })
        //////////// SETTINGS
        .when('/Admin/Settings', {
            controller: 'settingsController',
            templateUrl: 'churchplusapp/settings/view/SettingsAllView.html'
        })

        /* <<<<<<<<<<<< Added by Chris Ends */

        /* communication section by Victoria*/

        /*email*/
        .when('/Communication/NewEmail', {
            controller: 'emailcomposecontroller',
            templateUrl: 'churchplusapp/communication/view/Email/emailComposeView.html'
        })
            .when('/Communication/SentEmails', {
                controller: 'sentemailcontroller',
                templateUrl: 'churchplusapp/communication/view/Email/sentEmailView.html'
            })
            .when('/Communication/SentEmail/:id', {
                controller: 'emailcomposecontroller',
                templateUrl: 'churchplusapp/communication/view/Email/emailComposeView.html'
            })
            .when('/Communication/EmailDrafts', {
                controller: 'emaildraftcontroller',
                templateUrl: 'churchplusapp/communication/view/Email/emailDraftHomeView.html'
            })
            .when('/Communication/EmailDraft/:id', {
                controller: 'emailcomposecontroller',
                templateUrl: 'churchplusapp/communication/view/Email/emailComposeView.html'
            })
            .when('/Communication/SampleEmail', {
                controller: 'sampleemailscontroller',
                templateUrl: 'churchplusapp/communication/view/Email/sampleEmailMessagesView.html'
            })
            .when('/Communication/SampleEmail/:id', {
                controller: 'emailcomposecontroller',
                templateUrl: 'churchplusapp/communication/view/Email/emailComposeView.html'
            })

        /*sms*/

        .when('/Communication/NewSMS', {
            controller: 'smscomposecontroller',
            templateUrl: 'churchplusapp/communication/view/SMS/smsComposeView.html'
        })
            .when('/Communication/SMS', {
                controller: 'sentsmscontroller',
                templateUrl: 'churchplusapp/communication/view/SMS/smsHomeView.html'
            })
            .when('/Communication/SentSMS/:id', {
                controller: 'smscomposecontroller',
                templateUrl: 'churchplusapp/communication/view/SMS/smsComposeView.html'
            })

        .when('/Communication/SMSDrafts', {
            controller: 'smsdrafthomecontroller',
            templateUrl: 'churchplusapp/communication/view/SMS/SMSDraftView.html'
        })
            .when('/Communication/SMSDraft/:id', {
                controller: 'smscomposecontroller',
                templateUrl: 'churchplusapp/communication/view/SMS/smsComposeView.html'
            })

        .when('/Communication/SampleSMS', {
            controller: 'samplesmscontroller',
            templateUrl: 'churchplusapp/communication/view/SMS/sampleSMSMessageView.html'
        })
            .when('/Communication/SampleSMS/:id', {
                controller: 'smscomposecontroller',
                templateUrl: 'churchplusapp/communication/view/SMS/smsComposeView.html'
            })
            .when('/Communication/BuySms', {
                controller: '',
                templateUrl: 'churchplusapp/communication/view/SMS/smsPricingView.html'
            })
        //phone number groups

        .when('/Communication/SMS/PhoneNumberGroups', {
            controller: 'phonenumbergroupscontroller',
            templateUrl: 'churchplusapp/communication/view/SMS/phonenumbergroupsview.html'
        })
            .when('/Communication/SMS/NewPhoneContactGroup/:id', {
                controller: 'singlephonenumbergroupcontroller',
                templateUrl: 'churchplusapp/communication/view/SMS/phonenumbergroupNewEditView.html'
            })
            .when('/Communication/SMS/NewPhoneContactGroup', {
                controller: 'singlephonenumbergroupcontroller',
                templateUrl: 'churchplusapp/communication/view/SMS/phonenumbergroupNewEditView.html'
            })

        //followUp feedback

        .when('/FollowUpFeedBack', {
            controller: 'followUpController',
            templateUrl: 'churchplusapp/FollowUpFeedBack/view/followUpHomeView.html'
        })

        .when('/FollowUpFeedBack/NewEditFollowUp/:id', {
            controller: 'followUpNewEditController',
            templateUrl: 'churchplusapp/FollowUpFeedBack/view/followUpNewEditView.html'
        })

        .when('/FollowUpFeedBack/NewEditFollowUp', {
            controller: 'followUpNewEditController',
            templateUrl: 'churchplusapp/FollowUpFeedBack/view/followUpNewEditView.html'
        })



        /*prayers*/

        .when('/PrayerRequests', {
            controller: 'prayerRequestsController',
            templateUrl: 'churchplusapp/prayer/view/prayerRequestsView.html'
        })
            .when('/PrayerPoints', {
                controller: 'prayerPointsController',
                templateUrl: 'churchplusapp/prayer/view/prayerPointsView.html'
            })

        .when('/Prayers/NewPrayerPoint/:id', {
            controller: 'prayerPointNewEditController',
            templateUrl: 'churchplusapp/prayer/view/prayerpointNewEditView.html'
        })
            .when('/Prayers/NewPrayerPoint', {
                controller: 'prayerPointNewEditController',
                templateUrl: 'churchplusapp/prayer/view/prayerpointNewEditView.html'
            })
            .when('/Prayers/NewPrayerRequest/:id', {
                controller: 'prayerRequestNewEditController',
                templateUrl: 'churchplusapp/prayer/view/prayerRequestNewEditView.html'
            })
            .when('/Prayers/NewPrayerRequest', {
                controller: 'prayerRequestNewEditController',
                templateUrl: 'churchplusapp/prayer/view/prayerRequestNewEditView.html'
            })
        //Reporting Message
        .when('/Reports', {
            controller: '',
            templateUrl: 'churchplusapp/reports/view/reportView.html'
        }).when('/Reports/Membership/MembershipReport', {
            controller: '',
            templateUrl: 'churchplusapp/reports/view/Membership/membershipView.html'
        }).when('/Reports/Membership/FirstTimersReport', {
            controller: '',
            templateUrl: 'churchplusapp/reports/view/Membership/firstTimerView.html'
        }).when('/Reports/Membership/NewConvertsReport', {
            controller: '',
            templateUrl: 'churchplusapp/reports/view/Membership/newConvertView.html'
        }).when('/Reports/Membership/BirthdayReport', {
            controller: '',
            templateUrl: 'churchplusapp/reports/view/Membership/birthDayView.html'
        })
            .when('/Reports/ServicePerformanceReport', {
                controller: '',
                templateUrl: 'churchplusapp/reports/view/Performance/servicePerformanceView.html'
            }).when('/Reports/ServiceAttendanceReport', {
                controller: '',
                templateUrl: 'churchplusapp/reports/view/Performance/serviceAttendanceView.html'
            }).when('/Reports/FirstTimerPerformanceReport', {
                controller: '',
                templateUrl: 'churchplusapp/reports/view/Performance/firstTimerPerformanceView.html'
            }).when('/Reports/NewConvertPerformanceReport', {
                controller: '',
                templateUrl: 'churchplusapp/reports/view/Performance/newConvertPerformanceView.html'
            }).when('/Reports/Financial/ExpenseBasicReport', {
                controller: '',
                templateUrl: 'churchplusapp/reports/view/Financial/FinancialExpenseBasicView.html'
            }).when('/Reports/Financial/IncomeBasicReport', {
                controller: '',
                templateUrl: 'churchplusapp/reports/view/Financial/FinancialIncomeBasicView.html'
            }).when('/Reports/Financial/IncomeStatementReport', {
                controller: '',
                templateUrl: 'churchplusapp/reports/view/Financial/FinancialIncomeStatementView.html'
            }).when('/Reports/Financial/AccountingTransactions', {
                controller: '',
                templateUrl: 'churchplusapp/reports/view/Financial/FinancialAccountingTransactionsView.html'
            }).when('/Reports/Financial/ContributionReport', {
                controller: '',
                templateUrl: 'churchplusapp/reports/view/Financial/FinancialOfferingContributionView.html'
            })


        //Campaigns Messages
        .when('/Campaigns', {
            controller: 'campaignController',
            templateUrl: 'churchplusapp/campaign/view/campaignHomeView.html',
        })
            .when('/Campaigns/NewCampaign', {
                controller: 'campaignNewEditController',
                templateUrl: 'churchplusapp/campaign/view/campaignNewEditView.html',
            })
            .when('/Campaigns/EditCampaign/:id', {
                controller: 'campaignNewEditController',
                templateUrl: 'churchplusapp/campaign/view/campaignNewEditView.html',
            })


        //Accounting and Financial
        .when('/Accounting/Transactions', {
            controller: 'financialTransactionController',
            templateUrl: 'churchplusapp/accounting/view/financialTransactionsHomeView.html',
        })
            .when('/Accounting/Accounts', {
                //controller: 'financialAccountManagementcontroller',
                // controller: '',
                templateUrl: 'churchplusapp/accounting/view/financialChartOfAccounts.html'
            })
            .when('/Accounting/OfferingCategories', {
                controller: 'financialContributionsController',
                templateUrl: 'churchplusapp/accounting/view/financialContributionsHomeView.html',
            })
            .when('/Accounting/NewOfferingCategory', {
                controller: 'financialContributionAddEditController',
                templateUrl: 'churchplusapp/accounting/view/financialContributionAddEditView.html',
            })
            .when('/Accounting/EditOfferingCategory/:id', {
                controller: 'financialContributionAddEditController',
                templateUrl: 'churchplusapp/accounting/view/financialContributionAddEditView.html',
            })
            //.when('/Accounting/EditFinancialContribution/:id', {
            //    controller: 'financialContributionAddEditController',
            //    templateUrl: 'churchplusapp/accounting/view/financialContributionsAddEditView.html',
            //})
            .when('/Accounting/Transactions/ContributionTransactions', {
                controller: 'financialContributionTransactionscontroller',
                templateUrl: 'churchplusapp/accounting/view/financialContributionTransactionsHomeView.html',
            })
            .when('/Accounting/GeneralJournalTransactions', {
                controller: 'generalJournalTransactionController',
                templateUrl: 'churchplusapp/accounting/view/generalJournalTransactionsHomeView.html',
            })
            .when('/Accounting/GeneralJournalTransactions', {
                controller: 'generalJournalTransactionController',
                templateUrl: 'churchplusapp/accounting/view/generalJournalTransactionsHomeView.html',
            })
            .when('/Accounting/financialContributions', {
                controller: 'financialContributionCtrl',
                templateUrl: 'churchplusapp/accounting/view/financial.contribution.transaction.html',
            })
            .when('/Accounting/financialTransactions', {
                controller: 'financialTransactionCtrl',
                templateUrl: 'churchplusapp/accounting/view/financial.transaction.html',
            })
            .when('/Accounting/GeneralLedger', {
                controller: 'financialGeneralLedgerCtrl',
                templateUrl: 'churchplusapp/accounting/view/financial.generalLedger.html',
            })

        //schedule Message
        .when('/ScheduleMessages', {
            controller: 'scheduleMessageController',
            templateUrl: 'churchplusapp/scheduleMessages/view/scheduleMessageHomeView.html',
        })
            .when('/ScheduleMessages/NewEmailMessage', {
                controller: 'scheduleEmailMessageNewEditController',
                templateUrl: 'churchplusapp/scheduleMessages/view/scheduleEmailMessageNewEditView.html',
            })
            .when('/ScheduleMessages/EditEmailMessage/:id', {
                controller: 'scheduleEmailMessageNewEditController',
                templateUrl: 'churchplusapp/scheduleMessages/view/scheduleEmailMessageNewEditView.html',
            })
            .when('/ScheduleMessages/NewSMSMessage', {
                controller: 'scheduleSMSMessageNewEditController',
                templateUrl: 'churchplusapp/scheduleMessages/view/scheduleSMSMessageNewEditView.html',
            })
            .when('/ScheduleMessages/EditSMSMessage/:id', {
                controller: 'scheduleSMSMessageNewEditController',
                templateUrl: 'churchplusapp/scheduleMessages/view/scheduleSMSMessageNewEditView.html',
            })

        .when('/Media', {
            controller: 'mediaHomeController',
            templateUrl: 'churchplusapp/media/view/mediaHomeView.html'
        })
            .when('/Media/NewMedia', {
                controller: 'mediaNewEditController',
                templateUrl: 'churchplusapp/media/view/mediaNewEditView.html'
            })
            .when('/Media/EditMedia/:id', {
                controller: 'mediaNewEditController',
                templateUrl: 'churchplusapp/media/view/mediaNewEditView.html'
            })
            .when('/Media/ViewMedia/:name/:id', {
                controller: 'mediaNewEditController',
                templateUrl: 'churchplusapp/media/view/mediaPageView.html'
            })
        // User Management
        .when('/Admin/UserManagement', {
            controller: '',
            templateUrl: 'churchplusapp/admin/view/userManagementHomeView.html',
        })
            .when('/churchprofile', {
                controller: 'churchProfileNewEditController',
                templateUrl: 'churchplusapp/churchProfile/view/churchProfileNewEditView.html'
            }).otherwise({
                redirectTo: "/"
            })

        //Online Giving
        .when('/OnlineGiving/Donors', {
            controller: 'donorsController',
            templateUrl: 'churchplusapp/onlineGiving/view/donors.html',

        })
        .when('/OnlineGiving/Givings', {
            controller: 'givingsController',
            templateUrl: 'churchplusapp/onlineGiving/view/givings.html',

        })
        .when('/OnlineGiving/Payments', {
            controller: 'paymentsController',
            templateUrl: 'churchplusapp/onlineGiving/view/payments.html',

        })
        .when('/OnlineGiving/PaymentTransactionDetails/:paymentTransactionID', {
            controller: 'paymentTransactionDetailsController',
            templateUrl: 'churchplusapp/onlineGiving/view/paymentTransactionDetails.html',

        })
        .when('/OnlineGiving/Settings', {
            controller: 'onlineGivingSettingsController',
            templateUrl: 'churchplusapp/onlineGiving/view/onlineGivingSettings.html',

        });

    });

//churchplusapp.run(function($rootScope, $templateCache) {
//   $rootScope.$on('$viewContentLoaded', function() {
//      $templateCache.removeAll();
//   });
//});