﻿(function () {
    'use strict';
    var serviceId = 'communicationDataServices';

    churchplusapp.factory(serviceId, ['$http', '$q', 'dataservices', communicationDataServices]);

    function communicationDataServices($http, $q, dataservices) {

        var _sentSms = [];        
        var _sentEmails = [];    
        

       var _initSentSms = false;
       var _initSmsDrafts = false;
       var _initSentEmails = false;
       var _initEmailDrafts = false;

        var _phoneNumberGroups = [];
        var _initPhoneNumberGroups = false;

        var _sampleEmailMessages = [];
        var _sampleSmsMessages = [];

        var _initSampleEmailMessages = false;
        var _initSampleSmsMessages = false;

        var service = {

            sentSms: _sentSms,
            isSentSmsDataInitialized: isSentSmsDataInitialized,
            getSentSmsData: getSentSmsData,
            getSentSmsDataForEdit: getSentSmsDataForEdit,
            addSentSmsData: addSentSmsData,
            removeSentSmsData: removeSentSmsData,
            
            isSmsDraftDataInitialized: isSmsDraftDataInitialized,            
            addSmsDraftData: addSmsDraftData,
            removeSmsDraftData: removeSmsDraftData,

            sentEmails: _sentEmails,
            isSentEmailDataInitialized: isSentEmailDataInitialized,
            getSentEmailData: getSentEmailData,
            getSentEmailDataForEdit: getSentEmailDataForEdit,
            addSentEmailData: addSentEmailData,
            removeSentEmailData: removeSentEmailData,
            
            isEmailDraftDataInitialized: isEmailDraftDataInitialized,            
            addEmailDraftData: addEmailDraftData,
            removeEmailDraftData: removeEmailDraftData,          


            phoneNumberGroups: _phoneNumberGroups,
            isPhoneNumberGroupsDataInitialized: isPhoneNumberGroupsDataInitialized,
            getPhoneNumberGroupsData: getPhoneNumberGroupsData,
            getPhoneNumberGroupDataForEdit: getPhoneNumberGroupsDataForEdit,
            addPhoneNumberGroupData: addPhoneNumberGroupData,
            removePhoneNumberGroupData: removePhoneNumberGroupData,

            sampleEmailMessages: _sampleEmailMessages,
            isSampleEmailMessagesDataInitialized: isSampleEmailMessagesDataInitialized,
            getSampleEmailMessagesData: getSampleEmailMessagesData,
            getSampleEmailMessagesDataForEdit: getSampleEmailMessagesDataForEdit,
            getSMSBalance:getSMSBalance,

            sampleSmsMessages: _sampleSmsMessages,
            isSampleSmsMessagesDataInitialized: isSampleSmsMessagesDataInitialized,
            getSampleSmsMessagesData: getSampleSmsMessagesData,
            getSampleSmsMessagesDataForEdit: getSampleSmsMessagesDataForEdit

        };

        return service;

        //for sent sms

        function isSentSmsDataInitialized() {
            return _initSentSms;
        }


        function getSentSmsData() {
            var deferred = $q.defer();

            $http.get('api/MessagingController/getSentSMSMessages').then(function (result) {
                //successful call
                angular.copy(result.data, _sentSms);
                _initSentSms = true;

                deferred.resolve();
            },
            function () {
                //error in call
                deferred.reject();
            });
            return deferred.promise;
        }


        function getSentSmsDataForEdit(id) {
            var deferred = $q.defer();

            $http({
                method: 'get',
                url: 'api/MessagingController/getSingleSentMessage',
                params: { id: id }
            }).then(function (result) {
                //successful call

                deferred.resolve(result.data);
            },
            function () {
                //error in call
                deferred.reject();
            });
            return deferred.promise;
        }


        function removeSentSmsData(sentSmsMessages) {

            var deferred = $q.defer();

            $http.post('api/MessagingController/DeleteSentMessage', sentSmsMessages)
                .then(
                function (result) {

                    for (var a = 0; a < result.data.length; a++) {

                        for (var i = 0; i < _sentSms.length; i++) {

                            if (_sentSms[i].id == result.data[a].id) {

                                _sentSms.splice(_sentSms.indexOf(_sentSms[i]), 1);

                            }
                        }
                    }

                    deferred.resolve(result.data);
                },
                function () {
                    deferred.reject();
                })

            return deferred.promise;
        }


        function addSentSmsData(sentSmsData) {
            var deferred = $q.defer();

            var sentSmsDataToEdit;

            if (sentSmsData.id != null) {
                sentSmsDataToEdit = sentSmsData;
            }

            $http.post('api/MessagingController/SaveSMSSentMessage', sentSmsData).then(function (result) {

                if (sentSmsDataToEdit != null) {
                    for (var i = 0; _sentSms.length > i; i++) {
                        if (_sentSms[i].id === sentSmsData.id) {
                            //console.log(i);
                            _sentSms.splice(i, 1, sentSmsData);
                            break;
                        }
                    }
                } else {
                    _sentSms.splice(0, 0, result.data);
                }
                deferred.resolve(result.data);
            }, function (result) {
                deferred.reject(result.data);
            });

            return deferred.promise;
        }


        ////for sms drafts

        function isSmsDraftDataInitialized() {
            return _initSmsDrafts;
        }

        function removeSmsDraftData(drafts) {
            var deferred = $q.defer();

            $http.post('api/MessagingController/DeleteSMSDraft', drafts)
                .then(
                function (result) {                  

                    for (var a = 0; a < result.data.length; a++) {
                       
                        for (var i = 0; i < dataservices.smsDrafts.length; i++) {

                            if (dataservices.smsDrafts[i].id == result.data[a].id) {

                                dataservices.smsDrafts.splice(dataservices.smsDrafts.indexOf(dataservices.smsDrafts[i]), 1);
                               
                                }
                            }                        
                    }                  

                    deferred.resolve(result.data);
                },
                function () {
                    deferred.reject();
                })

            return deferred.promise;
        }


        function addSmsDraftData(SmsDraftData) {
            var deferred = $q.defer();

            var SmsDraftDataToEdit;

            if (SmsDraftData.id != null) {
                SmsDraftDataToEdit = SmsDraftData;
            }

            $http.post('api/MessagingController/SaveSMSDraft/', SmsDraftData).then(function (result) {

                if (SmsDraftDataToEdit != null) {
                    for (var i = 0; dataservices.smsDrafts.length > i; i++) {
                        if (dataservices.smsDrafts[i].id === SmsDraftData.id) {
                            //console.log(i);
                            dataservices.smsDrafts.splice(i, 1, SmsDraftData);
                            break;
                        }
                    }
                } else {
                    dataservices.smsDrafts.splice(0, 0, result.data);
                }
                deferred.resolve(result.data);
            }, function (result) {
                deferred.reject(result.data);
            });

            return deferred.promise;
        }
      

        //for email drafts

        function isEmailDraftDataInitialized() {
            return _initEmailDrafts;
        }

        function removeEmailDraftData(drafts) {
            var deferred = $q.defer();

            $http.post('api/MessagingController/DeleteEmailDraft/', drafts)
                 .then(
                 function (result) {

                     for (var a = 0; a < result.data.length; a++) {

                         for (var i = 0; i < dataservices.emailDrafts.length; i++) {

                             if (dataservices.emailDrafts[i].id == result.data[a].id) {

                                 dataservices.emailDrafts.splice(dataservices.emailDrafts.indexOf(dataservices.emailDrafts[i]), 1);

                             }
                         }
                     }

                     deferred.resolve(result.data);
                 },
                 function () {
                     deferred.reject();
                 })

            return deferred.promise;
        }


        function addEmailDraftData(emailDraftData) {
            var deferred = $q.defer();

            var emailDraftDataToEdit;

            if (emailDraftData.id != null) {
                emailDraftDataToEdit = emailDraftData;
            }

            $http.post('api/MessagingController/SaveEmailDraft/', emailDraftData).then(function (result) {

                if (emailDraftDataToEdit != null) {
                    for (var i = 0; dataservices.emailDrafts.length > i; i++) {
                        if (dataservices.emailDrafts[i].id === emailDraftData.id) {
                            //console.log(i);
                            dataservices.emailDrafts.splice(i, 1, emailDraftData);
                            break;
                        }
                    }
                } else {
                    dataservices.emailDrafts.splice(0, 0, result.data);
                }
                deferred.resolve(result.data);
            }, function (result) {
                deferred.reject(result.data);
            });

            return deferred.promise;
        }

        //for sent email

        function isSentEmailDataInitialized() {
            return _initSentEmails;
        }


        function getSentEmailData() {
            var deferred = $q.defer();

            $http.get('api/MessagingController/getSentEmailMessages').then(function (result) {
                //successful call
                angular.copy(result.data, _sentEmails);
                _initSentEmails = true;

                deferred.resolve();
            },
            function () {
                //error in call
                deferred.reject();
            });
            return deferred.promise;
        }


        function getSentEmailDataForEdit(id) {
            var deferred = $q.defer();

            $http({
                method: 'get',
                url: 'api/MessagingController/getSingleSentMessage',
                params: { id: id }
            }).then(function (result) {
                //successful call

                deferred.resolve(result.data);
            },
            function () {
                //error in call
                deferred.reject();
            });
            return deferred.promise;
        }


        function removeSentEmailData(sentEmailMessages) {

            var deferred = $q.defer();

            $http.post('api/MessagingController/DeleteSentMessage', sentEmailMessages)
                .then(
                function (result) {

                    for (var a = 0; a < result.data.length; a++) {

                        for (var i = 0; i < _sentEmails.length; i++) {

                            if (_sentEmails[i].id == result.data[a].id) {

                                _sentEmails.splice(_sentEmails.indexOf(_sentEmails[i]), 1);

                            }
                        }
                    }

                    deferred.resolve(result.data);
                },
                function () {
                    deferred.reject();
                })

            return deferred.promise;

            
        }


        function addSentEmailData(sentEmailData) {
            var deferred = $q.defer();

            var sentEmailDataToEdit;

            if (sentEmailData.id != null) {
                sentEmailDataToEdit = sentEmailData;
            }

            $http.post('api/MessagingController/SaveEmailSentMessage', sentEmailData).then(function (result) {

                if (sentEmailDataToEdit != null) {
                    for (var i = 0; _sentEmails.length > i; i++) {
                        if (_sentEmails[i].id === sentEmailData.id) {
                            //console.log(i);
                            _sentEmails.splice(i, 1, sentEmailData);
                            break;
                        }
                    }
                } else {
                    _sentEmails.splice(0, 0, result.data);
                }
                deferred.resolve(result.data);
            }, function (result) {
                deferred.reject(result.data);
            });

            return deferred.promise;
        }

        //for sample messages


        function isSampleEmailMessagesDataInitialized() {
            return _initSampleEmailMessages;
        }


        function getSampleEmailMessagesData() {
            var deferred = $q.defer();

            $http.get('api/MessagingController/getSampleEmailMessages').then(function (result) {
                //successful call
                angular.copy(result.data, _sampleEmailMessages);
                _initSampleEmailMessages = true;

                deferred.resolve();
            },
            function () {
                //error in call
                deferred.reject();
            });
            return deferred.promise;
        }


        function getSampleEmailMessagesDataForEdit(id) {
            var deferred = $q.defer();

            $http({
                method: 'get',
                url: 'api/MessagingController/getSingleSampleMessage',
                params: { id: id }
            }).then(function (result) {
                //successful call
                deferred.resolve(result.data);
            },
            function () {
                //error in call
                deferred.reject();
            });
            return deferred.promise;
        }


        function isSampleSmsMessagesDataInitialized() {
            return _initSampleSmsMessages;
        }


        function getSampleSmsMessagesData() {
            var deferred = $q.defer();

            $http.get('api/MessagingController/getSampleSMSMessages').then(function (result) {
                //successful call
                angular.copy(result.data, _sampleSmsMessages);
                _initSampleSmsMessages = true;

                deferred.resolve();
            },
            function () {
                //error in call
                deferred.reject();
            });
            return deferred.promise;
        }



        function getSampleSmsMessagesDataForEdit(id) {
            var deferred = $q.defer();

            $http({
                method: 'get',
                url: 'api/MessagingController/getSingleSampleMessage',
                params: { id: id }
            }).then(function (result) {
                //successful call
                deferred.resolve(result.data);
            },
            function () {
                //error in call
                deferred.reject();
            });
            return deferred.promise;
        }

        //for Phone number group

        function isPhoneNumberGroupsDataInitialized() {
            return _initPhoneNumberGroups;
        }


        function getPhoneNumberGroupsData() {
            var deferred = $q.defer();

            $http.get('api/MessagingController/getPhoneNumberGroups').then(function (result) {
                //successful call
                angular.copy(result.data, _phoneNumberGroups);
                _initPhoneNumberGroups = true;

                deferred.resolve();
            },
            function () {
                //error in call
                deferred.reject();
            });
            return deferred.promise;
        }
        function getPhoneNumberGroupsDataForEdit(id) {
            var deferred = $q.defer();

            $http({
                method: 'get',
                url: 'api/MessagingController/getSinglePhoneNumberGroup',
                params: { id: id }
            }).then(function (result) {
                //successful call
                deferred.resolve(result.data);
            },
            function () {
                //error in call
                deferred.reject();
            });
            return deferred.promise;
        }        
        function removePhoneNumberGroupData(phoneNumberGroups) {

            var deferred = $q.defer();

            $http.post('api/MessagingController/DeletePhoneNumberGroup', phoneNumberGroups)
                .then(
                function (result) {

                    for (var a = 0; a < result.data.length; a++) {

                        for (var i = 0; i < _phoneNumberGroups.length; i++) {

                            if (_phoneNumberGroups[i].id == result.data[a].id) {

                                _phoneNumberGroups.splice(_phoneNumberGroups.indexOf(_phoneNumberGroups[i]), 1);

                            }
                        }
                    }

                    deferred.resolve(result.data);
                },
                function () {
                    deferred.reject();
                })

            return deferred.promise;
            
        }                  
        function addPhoneNumberGroupData(phoneNumberGroupsData) {
            var deferred = $q.defer();

            var phoneNumberGroupsDataToEdit;

            if (phoneNumberGroupsData.id != null) {
                phoneNumberGroupsDataToEdit = phoneNumberGroupsData;
            }

            $http.post('api/MessagingController/SavePhoneNumberGroup', phoneNumberGroupsData).then(function (result) {

                if (phoneNumberGroupsDataToEdit != null) {
                    for (var i = 0; _phoneNumberGroups.length > i; i++) {
                        if (_phoneNumberGroups[i].id === phoneNumberGroupsData.id) {
                            //console.log(i);
                            _phoneNumberGroups.splice(i, 1, phoneNumberGroupsData);
                            break;
                        }
                    }
                } else {
                    _phoneNumberGroups.splice(0, 0, result.data);
                }
                deferred.resolve(result.data);
            }, function (result) {
                deferred.reject(result.data);
            });

            return deferred.promise;
        }
        function getSMSBalance() {
            var deferred = $q.defer();

            $http({
                method: 'get',
                url: 'api/MessagingController/getSMSBalance'               
            }).then(function (result) {
                //successful call
                deferred.resolve(result.data);
            },
            function () {
                //error in call
                deferred.reject();
            });
            return deferred.promise;
        }
    }
})();