﻿(function () {
    'use strict';

    var serviceId = 'dashboardDataservices';

    // TODO: replace app with your module name
    churchplusapp.factory(serviceId, ['$http', '$q', dashboardDataservices]);

    function dashboardDataservices($http, $q) {
        // Define the functions and properties to reveal.
        var _initBirthDayData = false;
        var _initGroupChartData = false;
        var _initMemberClassificationChartData = false;
        var _initGenderChartData = false;
        var _initMembershipSizeData = false;
        var _initMembersOnlySizeData = false;

        var _initFirstTimerSizeData = false;
        var _initNewConvertSizeData = false;
        var _initRetentionData = false;
        var _initEngagementData = false;
        var _initProfileData = false;
        var _initChurchPerformanceData = false;
        var _initChurchFinancialPerformanceData = false;

        var _groupChartData = [];
        var _churchPerformanceData = [];
        var _churchFinancialPerformanceData = [];


        var service = {
            getBirthDayData: getBirthDayData,
            getGroupChartData: getGroupChartData,
            getGenderChartData: getGenderChartData,
            getMemberClassficationData: getMemberClassficationData,
            getMembershipSizeData: getMembershipSizeData,
            getFirstTimerSizeData: getFirstTimerSizeData,
            getNewConvertSizeData: getNewConvertSizeData,
            getRententionData: getRententionData,
            getEngagementData: getEngagementData,
            getChurchProfileData: getChurchProfileData,
            getMembersOnlySizeData:getMembersOnlySizeData,
            getChurchPerformanceChartData: getChurchPerformanceChartData,
            getChurchFinancialPerformanceChartData: getChurchFinancialPerformanceChartData,

            groupChartData:_groupChartData,
            churchPerformanceData: _churchPerformanceData,
            churchFinancialPerformanceData :_churchFinancialPerformanceData,


            IsBirthDayDataInitialised: IsBirthDayDataInitialised,
            IsGroupChartDataInitialised: IsGroupChartDataInitialised,
            IsMemberClassificationInitialised: IsMemberClassificationInitialised,
            IsGenderChartDataInitialised: IsGenderChartDataInitialised,
            IsMembershipSizeDataInitialised: IsMembershipSizeDataInitialised,
            IsMembersOnlyDataInitialised:IsMembersOnlyDataInitialised,
            IsFirstTimerSizeDataInitialised: IsFirstTimerSizeDataInitialised,
            IsNewConvertSizeDataInitialised: IsNewConvertSizeDataInitialised,
            IsRententionDataInitialised: IsRententionDataInitialised,
            IsEngagementDataInitialised: IsEngagementDataInitialised,
            IsChurchProfileDataInitialised: IsChurchProfileDataInitialised,
            IsChurchFinancialPerformanceDataInitialised: IsChurchFinancialPerformanceDataInitialised,
            IsChurchPerformanceDataInitialised: IsChurchPerformanceDataInitialised



        };

        return service;

        function getBirthDayData() {
            var deferred = $q.defer();

            $http.get('api/DashboardController/getAnnivarsaryDayData').then(function (result) {
                //successful call
                //  angular.copy(result.data, _eventsData);
                _initBirthDayData = true;
                deferred.resolve(result.data);
            },
            function () {
                //error in call
                deferred.reject();
            });

            return deferred.promise;
        }
        function getGroupChartData() {
            var deferred = $q.defer();
            $http.get('api/DashboardController/getGroupChartData').then(function (result) {
                //successful call
                angular.copy(result.data, _groupChartData);
                _initGroupChartData = true;
                deferred.resolve(result.data);
            },
            function () {
                //error in call
                deferred.reject();
            });

            return deferred.promise;
        }
        function getGenderChartData() {
            var deferred = $q.defer();
            $http.get('api/DashboardController/getMembersByGenderData').then(function (result) {
                //successful call
                _initGenderChartData = true;
                deferred.resolve(result.data);
            },
            function () {
                //error in call
                deferred.reject();
            });

            return deferred.promise;
        }
        function getMemberClassficationData() {
            var deferred = $q.defer();
            $http.get('api/DashboardController/getMembersByClassificationGroupData').then(function (result) {
                //successful call
                _initMemberClassificationChartData = true;
                deferred.resolve(result.data);
            },
            function () {
                //error in call
                deferred.reject();
            });

            return deferred.promise;
        }

        function getMembershipSizeData(startdate, enddate) {
            var deferred = $q.defer();
            $http({
                method: 'get',
                url: 'api/DashboardController/getMembershipSizeData?startdate=' + startdate + '&enddate=' + enddate
            }).then(function (result) {
                //successful call
                _initMembershipSizeData = true;
                deferred.resolve(result.data);
            },
            function () {
                //error in call
                deferred.reject();
            });

            return deferred.promise;
        }
        function getMembersOnlySizeData(startdate, enddate) {
            var deferred = $q.defer();
            $http({
                method: 'get',
                url: 'api/DashboardController/getMembersOnlyInSizeData?startdate=' + startdate + '&enddate=' + enddate
            }).then(function (result) {
                //successful call
                _initMembersOnlySizeData = true;
                deferred.resolve(result.data);
            },
            function () {
                //error in call
                deferred.reject();
            });

            return deferred.promise;
        }

        function getFirstTimerSizeData(startdate, enddate) {
            var deferred = $q.defer();
            $http({
                method: 'get',
                url: 'api/DashboardController/getFirstTimerSizeData?startdate=' + startdate + '&enddate=' + enddate
            }).then(function (result) {
                //successful call
                _initFirstTimerSizeData = true;
                deferred.resolve(result.data);
            },
            function () {
                //error in call
                deferred.reject();
            });

            return deferred.promise;
        }
        function getNewConvertSizeData(startdate, enddate) {
            var deferred = $q.defer();
            $http({
                method: 'get',
                url: 'api/DashboardController/getNewConvertSizeData?startdate=' + startdate + '&enddate=' + enddate
            }).then(function (result) {
                //successful call
                _initNewConvertSizeData = true;
                deferred.resolve(result.data);
            },
            function () {
                //error in call
                deferred.reject();
            });

            return deferred.promise;
        }
        function getRententionData(startdate, enddate) {
            var deferred = $q.defer();
            $http({
                method: 'get',
                url: 'api/DashboardController/getFirstTimerRetentionData?startdate=' + startdate + '&enddate=' + enddate                
            }).then(function (result) {
                //successful call
                _initRetentionData = true;
                deferred.resolve(result.data);
            },
            function () {
                //error in call
                deferred.reject();
            });

            return deferred.promise;
        }
        function getEngagementData(startdate, enddate) {
            var deferred = $q.defer();
            $http({
                method: 'get',
                url: 'api/DashboardController/getMembershipEngagement?startdate=' + startdate + '&enddate=' + enddate
            }).then(function (result) {
                //successful call
                _initEngagementData = true;
                deferred.resolve(result.data);
            },
            function () {
                //error in call
                deferred.reject();
            });

            return deferred.promise;
        }
        function getChurchProfileData()
        {
            var deferred = $q.defer();
            $http.get('api/DashboardController/ChurchProfileInformation').then(function (result) {
                //successful call
                _initProfileData = true;
                deferred.resolve(result.data);
            },
            function () {
                //error in call
                deferred.reject();
            });

            return deferred.promise;

        }
        function getChurchPerformanceChartData(startdate,enddate)
        {
            var deferred = $q.defer();
            $http({
                method: 'get',
                url: 'api/DashboardController/ChurchPerformanceChartData?startdate=' + startdate + '&enddate=' + enddate
            }).then(function (result) {
                //successful call
                angular.copy(result.data, _churchPerformanceData);
                _initChurchPerformanceData = true;
                deferred.resolve(result.data);
            },
            function () {
                //error in call
                deferred.reject();
            });

            return deferred.promise;
           
        }

        function getChurchFinancialPerformanceChartData(startdate, enddate) {
            var deferred = $q.defer();
            $http({
                method: 'get',
                url: 'api/DashboardController/ChurchFinancialPerformanceChartData?startdate=' + startdate + '&enddate=' + enddate
            }).then(function (result) {
                //successful call
                angular.copy(result.data, _churchFinancialPerformanceData);
                _initChurchFinancialPerformanceData = true;
                deferred.resolve(result.data);
            },
            function () {
                //error in call
                deferred.reject();
            });

            return deferred.promise;

        }
        
        //#region Internal Methods        
        function IsBirthDayDataInitialised() {
            return _initBirthDayData;
        }
        function IsGroupChartDataInitialised() {
            return _initGroupChartData;
        }
        function IsGenderChartDataInitialised() {
            return _initGenderChartData;
        }
        function IsMemberClassificationInitialised() {
            return _initMemberClassificationChartData;
        }
        function IsMembershipSizeDataInitialised() {
            return _initMembershipSizeData;
        }
        function IsMembersOnlyDataInitialised() {
            return _initMembersOnlySizeData;
        }

        function IsFirstTimerSizeDataInitialised() {
            return _initFirstTimerSizeData;
        }
        function IsNewConvertSizeDataInitialised() {
            return _initNewConvertSizeData;
        }
        function IsRententionDataInitialised() {
            return _initRetentionData;
        }
        function IsEngagementDataInitialised() {
            return _initEngagementData;
        }
        function IsChurchProfileDataInitialised() {
            return _initProfileData;
        }
        function IsChurchPerformanceDataInitialised()
        {
            return _initChurchPerformanceData;

        }
        function IsChurchFinancialPerformanceDataInitialised() {

            return _churchFinancialPerformanceData;

        }
        
        
        //#endregion

    }
})();