﻿(function () {
    'use strict';

    var serviceId = 'dataservices';

    // TODO: replace app with your module name
    churchplusapp.factory(serviceId, ['$http', '$q', dataservices]);

    function dataservices($http, $q) {
        // Define the functions and properties to reveal.

        var _lookUpData = { MembershipClassification: [], MaritalStatus: [], AgeGroup: [] };
        var _communicationLookUpData = {};
        var _islookInitialised = false;
        var _iscommunicationlookInitialised = false;
        var smsDrafts = [];
        var emailDrafts = [];

        var service = {

            smsDrafts: smsDrafts,
            emailDrafts:emailDrafts,
            getEmailDrafts: getEmailDrafts,
            getEmailDraftByID: getEmailDraftByID,
            getSMSDrafts: getSMSDrafts,
            getSMSDraftByID: getSMSDraftByID,
            getPersonSearch: getPersonSearch,
            getPeopleInformation: getPeopleInformation,
            getCommunicationGroupedData: getCommunicationGroupedData,
            getLookUpInformation: getLookUpInformation,
            IsLookUpDataInitialized: IsLookUpDataInitialized,
            IsCommunicationLookUpDataInitialized: IsCommunicationLookUpDataInitialized,
            lookUpData: _lookUpData,
            communicationLookUpData: _communicationLookUpData,
            getAllRecentEventDetails: getAllRecentEventDetails,
            getAllEvents: getAllEvents,
            getAllAttendanceCategories: getAllAttendanceCategories,

            getAllAutomatedFollowUp: getAllAutomatedFollowUp,

            sendEmails: sendEmails,
            checkBalanceAndSendSMS: CheckBalanceAndSendSMS

        };

        return service;



        function getEmailDrafts() {

            var deferred = $q.defer();

            $http.get('api/emailDrafts/getEmailDrafts').then(function (result) {
                //successful call
                angular.copy(result.data, emailDrafts);
                deferred.resolve(result.data);
            },
            function () {
                //error in call
                deferred.reject();
            });
            return deferred.promise;
        }
        function getEmailDraftByID(id) {
            var deferred = $q.defer();

            $http({
                method: 'get',
                url: 'api/emaildrafts/getEmailDraftByID',
                params: { id: id }
            }).then(function (result) {
                //successful call

                deferred.resolve(result.data);
            },
            function () {
                //error in call
                deferred.reject();
            });
            return deferred.promise;
        }
        function getSMSDrafts() {

            var deferred = $q.defer();

            $http.get('api/smsDrafts/getSMSDrafts').then(function (result) {
                //successful call
                angular.copy(result.data, smsDrafts);
                deferred.resolve(result.data);
            },
            function () {
                //error in call
                deferred.reject();
            });
            return deferred.promise;
        }

        function getAllRecentEventDetails() {
            var deferred = $q.defer();

            $http({
                method: 'get',
                url: 'api/EventsController/getAllRecentEventActivities'
            }).then(function (result) {
                //successful call

                deferred.resolve(result.data);
            },
            function () {
                //error in call
                deferred.reject();
            });
            return deferred.promise;
        }

        function getAllEvents() {
            var deferred = $q.defer();

            $http({
                method: 'get',
                url: 'api/EventsController/getAllEventsForSelect'
            }).then(function (result) {
                //successful call

                deferred.resolve(result.data);
            },
            function () {
                //error in call
                deferred.reject();
            });
            return deferred.promise;
        }

        function getAllAttendanceCategories() {
            var deferred = $q.defer();

            $http({
                method: 'get',
                url: 'api/EventsController/getAttendanceCategories'
            }).then(function (result) {
                //successful call
                //
                deferred.resolve(result.data);
            },
            function () {
                //error in call
                deferred.reject();
            });
            return deferred.promise;
        }

        function getAllAutomatedFollowUp() {
            var deferred = $q.defer();

            $http({
                method: 'get',
                url: 'api/MessagingController/getAutomatedFollowupList'
            }).then(function (result) {
                //successful call

                deferred.resolve(result.data);
            },
            function () {
                //error in call
                deferred.reject();
            });
            return deferred.promise;
        }
        function getSMSDraftByID(id) {
            var deferred = $q.defer();

            $http({
                method: 'get',
                url: 'api/smsdrafts/getSMSDraftByID',
                params: { id: id }
            }).then(function (result) {
                //successful call

                deferred.resolve(result.data);
            },
            function () {
                //error in call
                deferred.reject();
            });
            return deferred.promise;
        }
        function getPersonSearch(_query) {
            var deferred = $q.defer();

            $http({
                method: 'get',
                url: 'api/MembershipController/personSearch',
                params: { query: _query }
            }).then(function (result) {
                //successful call

                deferred.resolve(result.data);
            },
            function () {
                //error in call
                deferred.reject();
            });
            return deferred.promise;
        }
        function getPeopleInformation(_query) {
            var deferred = $q.defer();

            $http({
                method: 'get',
                url: 'api/MembershipController/peopleBasicInformation',
                params: { query: _query }
            }).then(function (result) {
                //successful call

                deferred.resolve(result.data);
            },
            function () {
                //error in call
                deferred.reject();
            });
            return deferred.promise;
        }
        function CheckBalanceAndSendSMS(messageObject) {
            var deferred = $q.defer();

            $http.post('/api/MessagingController/CheckIfClientHasEnoughCreditAndSendSMS/', messageObject).then(function (result) {
                deferred.resolve(result.data);

            }, function () {
                //Error Function
                deferred.reject();
            });

            return deferred.promise;
        }


        /// <summary>
        /// Sends SMS. checks if the client has enough air time for the transaction if true, proceeds else return with a message
        /// </summary>
        /// <param name="messageObject"></param>
        /// <returns>True if all the parameters are right else false with message</returns>
        function sendSMS(messageObject) {
            var deferred = $q.defer();
            $http.post('/api/MessagingController/SendSMS/', messageObject).then(function (result) {

                deferred.resolve(result.data);
            }, function () {

                //Error Function
                deferred.reject();

            });
            return deferred.promise;
        }

        /// <summary>
        /// Sends Email to the selected contacts.
        /// </summary>
        /// <param name="messageObject"></param>
        /// <returns>True if all the parameters are right else false with message</returns>
        function sendEmails(messageObject) {
            var deferred = $q.defer();

            $http.post('/api/MessagingController/SendEmail/', messageObject).then(function (result) {

                deferred.resolve(result);
            }, function () {

                //Error Function
                deferred.reject();

            });

            return deferred.promise;
        }

        function getLookUpInformation() {

            var deferred = $q.defer();

            $http.get('api/LookUpController/getMembershipClassification').then(function (result) {
                //successful call
                _lookUpData.MembershipClassification = result.data;

                $http.get('api/LookUpController/getMaritalStatus').then(function (result) {
                    //successful call
                    _lookUpData.MaritalStatus = result.data;
                    $http.get('api/LookUpController/getAgeGroup').then(function (result) {
                        //successful call
                        _lookUpData.AgeGroup = result.data;
                        _islookInitialised = true;
                        deferred.resolve(_lookUpData);

                    },
           function () {
               //Error Function
               deferred.reject();
           });
                },
            function () {
                //Error Function
                deferred.reject();
            });
            },
            function () {
                //Error Function
                deferred.reject();
            });
            return deferred.promise;
        }

        function getCommunicationGroupedData() {

            var deferred = $q.defer();
            $q.all({
                membership: MembershipGroupData(), group: GroupsGroupData(), gender: GenderGroupData(),
                marital: MaritalStatusGroupData(),
                house: HouseFellowshipGroupData(), age: AgeGroupData(), phoneGroup:PhoneGroupData()
            }).then(function (result) {

                _iscommunicationlookInitialised = true;
                deferred.resolve(result);

            });

            return deferred.promise;
        }


      
        function MembershipGroupData() {

            var deferred = $q.defer();

            $http.get('api/LookUpController/getMembershipClassification').then(function (result) {
                //successful call
                deferred.resolve(result.data);
            },
            function () {
                //error in call
                deferred.reject();
            });
            return deferred.promise;
        }
        function MaritalStatusGroupData() {

            var deferred = $q.defer();

            $http.get('api/LookUpController/getMaritalStatus').then(function (result) {
                //successful call
                deferred.resolve(result.data);
            },
            function () {
                //error in call
                deferred.reject();
            });
            return deferred.promise;
        }
        function AgeGroupData() {

            var deferred = $q.defer();

            $http.get('api/LookUpController/getAgeGroup').then(function (result) {
                //successful call
                deferred.resolve(result.data);
            },
            function () {
                //error in call
                deferred.reject();
            });
            return deferred.promise;
        }
        function GroupsGroupData() {

            var deferred = $q.defer();

            $http.get('/api/GroupsApi').then(function (result) {
                //successful call
                deferred.resolve(result.data);
            },
            function () {
                //error in call
                deferred.reject();
            });
            return deferred.promise;
        }
        function HouseFellowshipGroupData() {

            var deferred = $q.defer();

            $http.get('api/HouseFellowshipController/GetHouseFellowshipData').then(function (result) {
                //successful call
                deferred.resolve(result.data);
            },
            function () {
                //error in call
                deferred.reject();
            });
            return deferred.promise;
        }
        function PhoneGroupData() {

            var deferred = $q.defer();

            $http.get('api/LookUpController/getPhoneGroup').then(function (result) {
                //successful call
                deferred.resolve(result.data);
            },
            function () {
                //error in call
                deferred.reject();
            });
            return deferred.promise;
        }
        function GenderGroupData() {

            var deferred = $q.defer();
            var male = { id: '', text: '' };
            var female = { id: '', text: '' };
            var gender = [];

            male.id = '1';
            male.text = 'Male'

            female.id = 's2';
            female.text = 'Female'
            gender.push(male);
            gender.push(female);
            //successful call
            deferred.resolve(gender);
            return deferred.promise;
        }




        function IsLookUpDataInitialized() {
            return _islookInitialised;
        }
        function IsCommunicationLookUpDataInitialized() {
            return _iscommunicationlookInitialised;
        }
    }
})();