﻿(function () {
    'use strict';

    var controllerId = 'emaildraftcontroller';

    // TODO: replace app with your module name
    churchplusapp.controller(controllerId, ['$scope', 'dataservices', 'communicationDataServices', 'notificationFactory','$filter', 'ngTableParams', emaildraftcontroller]);

    function emaildraftcontroller($scope, dataservices, communicationDataServices, notificationFactory,$filter, ngTableParams) {
        $scope.title = 'emaildraftcontroller';
        $scope.emailDrafts = dataservices.emailDrafts;
        $scope.emailDrafts.isSelected = false;

        ////////////////////////   Initialize the list of email drafts   /////////////////////////////////

        dataservices.getEmailDrafts().then(function (result) { }, function () { })


        /////////////// ngTable
        function ngTableFunction() {
            $scope.tableParams = new ngTableParams({
                page: 1,            // show first page
                count: 10,          // count per page
                sorting: {
                    name: 'asc'     // initial sorting
                }
            }, {
                total: $scope.emailDrafts.length, // length of data
                getData: function ($defer, params) {
                    // use build-in angular filter
                    var orderedData = params.sorting() ? $filter('orderBy')($scope.emailDrafts, params.orderBy()) : $scope.emailDrafts;

                    $defer.resolve(orderedData.slice((params.page() - 1) * params.count(), params.page() * params.count()));
                }
            });
        }
        


        ////////////////////////     refresh the list of email drafts   /////////////////////////////////        

        $scope.Refresh = function () {
            dataservices.getEmailDrafts().then(function (result) {},
                function () {
                    //Error refreshing data set
                    notificationFactory.error('Can not retrive data from the server now, please check internet connections and try again');
                });
        }

        ////////////////////////     Delete email draft   /////////////////////////////////

        function getSelectedMessages() {
            var messagesArray = [];
            for (var i = 0; i < $scope.emailDrafts.length; i++) {

                if ($scope.emailDrafts[i].isSelected == true) {
                    var messageDraft = {};

                    messageDraft.id = $scope.emailDrafts[i].id;
                    messageDraft.text = $scope.emailDrafts[i].text;
                    messageDraft.message = $scope.emailDrafts[i].message;
                    messageDraft.date = $scope.emailDrafts[i].date;
                    messagesArray.push(messageDraft);
                }
            }

            return messagesArray;
        }

        $scope.Delete = function () {

            if (getSelectedMessages().length < 1) {
                notificationFactory.error('Please select Draft to delete');
            }
            else {
                //make a call to the delete service pass the array of messages
                var selectedMessages = getSelectedMessages();

                communicationDataServices.removeEmailDraftData(selectedMessages)
                    .then(function (result) {

                        notificationFactory.success('drafts Deleted');

                    },
                 function () {

                     notificationFactory.error('Delete not successful, please check the internet and try again.');

                 });
            }

        }


    }
})();
