﻿(function () {
    'use strict';

    var controllerId = 'eventNewEditController';

    // TODO: replace app with your module name
    churchplusapp.controller(controllerId,
        ['$scope', 'dataservices', 'eventsDataService', 'notificationFactory', '$window', '$routeParams', eventNewEditController]);

    function eventNewEditController($scope, dataservices, eventsDataService, notificationFactory, $window, $routeParams) {
        $scope.title = 'eventNewEditController';
        $scope.activate = activate;
        $scope.event = { reminders: [] };
        var reminder = { subject: '', message: '', whenToSend: '', channel: '' };
        // $scope.showDay = true;

        if ($routeParams.id != null) {
            //Load the Events Category from the EventsDataService
            eventsDataService.getEventDataByID($routeParams.id).then(function (result) {

                $scope.event = result;
                var data = {};

                data.id = $scope.event.reOccurancePattern;
                $('#select-occurance').select2('val', data.id);

                if ($scope.event.reOccurancePattern == 3) {
                    //show the day control
                    $('#select-day').select2('val', $scope.event.weeklyEventDay);
                    $('.hideDay').show();

                } else {
                    $('.hideDay').hide();

                }

                $scope.event.eventTime = $('#spinner-time').val($scope.event.eventTime);
            }, function () { });

        }


        //The add sms reminder functionality
        $scope.SaveSMSReminder = function () {
            var reminder = { subject: '', message: '', whenToSend: '', channel: '' };
            reminder.subject = $scope.smsSubject;
            reminder.message = $scope.smsMessage;
            reminder.channel = 'SMS';
            var d = $('#sms-select-when-to-send').select2('data');
            reminder.whenToSend = d.text;
            reminder.actualSendTimeInMins = d.id;
            $scope.event.reminders.push(reminder);

        }

        // This is to send email
        $scope.SaveEmailReminder = function () {
            var reminder = { subject: '', message: '', whenToSend: '', channel: '' };
            reminder.subject = $scope.emailSubject;
            reminder.message = $scope.emailMessage;
            reminder.channel = 'Email';
            var d = $('#email-select-when-to-send').select2('data');
            reminder.whenToSend = d.text;
            reminder.actualSendTimeInMins = d.id;
            $scope.event.reminders.push(reminder);

        }
        //This function saves the event entity to the database
        $scope.Save = function () {
            var dataOccurance = $('#select-occurance').select2('data');
            var dataDay = $('#select-day').select2('data');

            if (dataOccurance == null) {
                notificationFactory.info('Please select reoccurance type to continue');
                return;
            }
            if (dataDay != null) {
                $scope.event.weeklyEventDay = dataDay.id;

            }
            //map the attributes
            $scope.event.reOccurancePattern = dataOccurance.id;
            $scope.event.eventTime = $('#spinner-time').val();
            eventsDataService.saveChurchEventData($scope.event).then(function (result) {
                $window.location = "#/Events/All"
            }, function () {
                notificationFactory.error("Unsuccessful Operation");

            });
        }

        //This function removes the reminder from the list.
        $scope.Remove = function (Reminder) {

            if (confirm('You are about to remove the reminder ' + Reminder.subject + ' Reminder')) {
                if (Reminder.id == null) {
                    $scope.event.reminders.splice($scope.event.reminders.indexOf(Reminder), 1);
                    notificationFactory.success('Event Reminder successfully removed from the system');

                } else {
                    // make a call to the server and remove the reminder
                    eventsDataService.removeEventReminderData(Reminder.id).then(function () {
                        //Successfully Deleted the reminder
                        $scope.event.reminders.splice($scope.event.reminders.indexOf(Reminder), 1);
                        notificationFactory.success('Event Reminder successfully removed from the system');
                    }, function () { });
                }
            }
        }
        //load the email drafts
        dataservices.getEmailDrafts().then(function (emails) {

            $("#emaildraftselect").select2({
                placeholder: 'Select From Drafts',
                data: emails,
                width: "100%"         //

            }).on("change", function (e) {

                //call the get email service

                dataservices.getEmailDraftByID(e.val).then(function (emaildraft) {

                    $scope.emailSubject = emaildraft.subject;
                    $scope.emailMessage = emaildraft.message;
                    $('#emailMessage').data("wysihtml5").editor.setValue(emaildraft.message);


                }, function () {
                    //error
                    notificationFactory.error("Unsuccessful");

                });

            });

        }, function () {
            // Error
        });

        dataservices.getSMSDrafts().then(function (sms) {
            $("#smsdraftselect").select2({
                placeholder: 'Select From SMS Drafts',
                data: sms,
                width: "100%"
            }).on("change", function (e) {

                //call the get email service

                dataservices.getSMSDraftByID(e.val).then(function (smsdraft) {

                    $scope.smsSubject = smsdraft.sender;
                    $scope.smsMessage = smsdraft.body;

                }, function () {

                    //Error
                    notificationFactory.error("Unsuccessful");

                });

            });

        }, function () {
            //Error
        });

        function activate() { }
        $(".datepicker").datepicker({
            showOtherMonths: true
        });
        // $("#spinner-time").spinner();
        $("#spinner-time").timespinner();

        $('.editor').wysihtml5({
            stylesheets: "css/wysihtml5/wysiwyg-color.css"
        });

        $("#select-day").select2({
            placeholder: 'Select Day',
            width: "100%"
        });
        $(".time-select").select2({
            placeholder: 'Select Time ',
            width: "100%"
        });
        $("#select-occurance").select2({
            placeholder: 'Select',
            width: "100%"
        }).on("change", function (e) {

            if (e.val == 3) {
                $('.hideDay').show();
            } else {
                $('.hideDay').hide();

            }
        });

    }
})();
