﻿(function () {
    'use strict';

    var controllerId = 'eventsReportController';

    // TODO: replace app with your module name
    churchplusapp.controller(controllerId,
        ['$scope', 'eventsDataService', 'notificationFactory', eventsReportController]);

    function eventsReportController($scope, eventsDataService, notificationFactory) {
        $scope.title = 'eventReportController';
        $scope.activate = activate;
        $scope.data = eventsDataService;

        //load the EventsReport

        if (eventsDataService.IsEventsReportDataInitialised() == false) {
            eventsDataService.getActivitiesReportData().then(function () { }, function () {
                //display message about internet connection
                notificationFactory.error('Could not retrieve data, please check internet connection and try again');
            });
        }

        $scope.Refresh = function () {
            eventsDataService.getActivitiesReportData().then(function () {
                //Success do nothing the data will be picked from the eventdataService factory
            }, function () {
                notificationFactory.error('Could not retrieve data, please check internet connection and try again');
            });
        }

        $scope.Remove = function (p) {

            if (confirm('You are about to delete ' + p.name)) {
                //Delet the activity and pull it from the data.
                eventsDataService.removeActivityReportData(p).then(function () {
                    //Success do nothing the data will be picked from the eventdataService factory
                    notificationFactory.success(p.name + " deleted");

                }, function () {
                    notificationFactory.error('Could not delete activity report, please check internet connection and try again');
                });

            };
        }

        /////////////////////// file upload

        $scope.onFileSelect = function ($files) {
            $scope.selectedFile = $files[0];
        };

        $scope.UploadExcelFile = function () {
            $scope.upload = $upload.upload({
                url: 'api/ExcelUploadController/UploadExcelFile',
                method: "POST",
                file: $scope.selectedFile

            }).success(function (data, status, headers, config) {
                eventsDataService.getActivitiesReportData().then(function () {
                    //Success do nothing the data will be picked from the eventdataService factory
                }, function () {
                    notificationFactory.error('Could not retrieve data, please check internet connection and try again');
                });
                notificationFactory.success(data.response);
            });

        }

        function activate() { }
    }
})();
