﻿(function () {
    'use strict';

    var controllerId = 'eventReportNewEditController';

    // TODO: replace app with your module name
    churchplusapp.controller(controllerId,
        ['$scope', 'eventsDataService', 'dataservices', 'notificationFactory', 'membershipdataservices', '$timeout', '$window', '$routeParams', eventReportNewEditController]);

    function eventReportNewEditController($scope, eventsDataService, dataservices, notificationFactory, membershipdataservices, $timeout, $window, $routeParams) {
        $scope.title = 'eventReport NewEdit Controller';
        $scope.activate = activate;
        $scope.activity = {};
        var activityID;

        $scope.activity.attendances = [];
        $scope.activity.firstTimers = [];
        $scope.activity.converts = [];
        $scope.firstTimerSelectionValue = false;
        $scope.newConvertSelectionValue = false;
        $scope.firstTimer = { person: { eventID: '' } };
        Array.prototype.sum = function (prop) {
            var total = 0
            for (var i = 0, _len = this.length; i < _len; i++) {
                total += this[i][prop]
            }
            return total
        }
        var eventID;

        if ($routeParams.id == null) {
            //Load the Events Category from the EventsDataService
            dataservices.getAllEvents().then(function (events) {
                $("#select-event").select2({
                    placeholder: 'Select From Events and Activities',
                    data: events,
                    width: "100%"
                });
            }, function () { });
        }
        else {
            eventsDataService.getActivitiesReportDataByID($routeParams.id).then(function (activity) {

                //assign the activity ID to a global variable
                activityID = activity.id;

                //Format the returned data to suit the model used in the first timers and converts view.

                for (var i = 0; i < activity.firstTimers.length; i++) {
                    var person = {};

                    if (activity.firstTimers[i].person.lastName != null) {
                        person.name = activity.firstTimers[i].person.firstName + activity.firstTimers[i].person.lastName

                    } else {
                        person.name = activity.firstTimers[i].person.firstName;
                    }

                    person.phone = activity.firstTimers[i].person.mobilePhone;
                    person.email = activity.firstTimers[i].person.email;
                    person.id = activity.firstTimers[i].person.id;

                    activity.firstTimers[i].person = person;
                }

                for (var i = 0; i < activity.converts.length; i++) {
                    var person = {};

                    if (activity.converts[i].person.lastName != null) {
                        person.name = activity.converts[i].person.firstName + " " + activity.converts[i].person.lastName

                    } else {
                        person.name = activity.converts[i].person.firstName;
                    }
                    person.phone = activity.converts[i].person.mobilePhone;
                    person.email = activity.converts[i].person.email;
                    person.id = activity.converts[i].person.id;

                    activity.converts[i].person = person;
                }
                $scope.activity = activity;

                //Load the Events Category from the EventsDataService
                dataservices.getAllEvents().then(function (events) {
                    $("#select-event").select2({
                        placeholder: 'Select From Events and Activities',
                        data: events,
                        width: "100%"
                    });
                    // check if this is an edit and set the value 
                   //  to the correct 
                    var data = {};

                    data.text = $scope.activity.event.name;
                    data.id = $scope.activity.event.id;

                   $("#select-event").select2("data", {id: data.id,text: data.text});

                }, function () { });


                //recalculate the attendance total
                $scope.totalAttendance = $scope.activity.attendances.sum('number');

                
            }, function () {
                //Use Toaster Alert Note
                notificationFactory.error("Getting the event report Information, try again");

            })

        }





        dataservices.getAllAttendanceCategories().then(function (events) {
            $("#select-attendanceCategory").select2({
                placeholder: 'Select Attendace Category',
                data: events,
                width: "100%"
            })
        }, function () { });

        //Load the automated followup list
        dataservices.getAllAutomatedFollowUp().then(function (data) {
            data.splice(0, 0, { id: '', text: 'none' })
            $("#selected-automatedfollowup").select2({
                placeholder: 'Select From Automated FollowUp List',
                data: data,
                width: "100%"
            })

        }, function () {
            //Error
            notificationFactory.error('Could not load automated followup data from the server.please check your internet connection..');
        });

        //  eventsDataService.getActivitiesReportDataByID("1c55e3e5-4ca8-4e9e-be86-fa5d51b3b713").then(function () { }, function () { });

        //The function when add attendace is clicked.
        $scope.AddAttendance = function () {
            //check that the count is numeric and that user selected something
            var data = $('#select-attendanceCategory').select2('data');
            if (isNaN($scope.at.count) == true || data.id == null || data.id == '') {

                notificationFactory.error("Please select a valid category and enter a numeric value in the count textbox");
                return
            } else {
                //continue with the operations
                var attendance = { attendanceType: { id: '', name: '' }, attendanceTypeID: '', id: '', number: '' };
                attendance.number = $scope.at.count;
                attendance.attendanceType.id = data.id;
                attendance.attendanceTypeID = data.id;
                attendance.attendanceType.name = data.text;
                //Save the attendance to the system.

                // Add the object to the attendances array
                $scope.activity.attendances.push(attendance);

                $scope.totalAttendance = $scope.activity.attendances.sum('number');
            }
        }

        //The function for adding first timers to the event list
        $scope.AddFirstTimers = function () {
            $scope.contactForm.$invalid = false;

            var firstTimer = {};

            // $scope.contactForm.$invalid = true;
            var data = $("#select-gender").select2('data');

            //check if gender is selected to avoid null error
            if (data != null) {

                $scope.firstTimer.person.genderID = data.id;
                $scope.firstTimer.person.gender = data.text;
            }


            $scope.firstTimer.person.maritalStatusID = $("#select-maritalStatus").val();
            $scope.firstTimer.person.automatedFollowUpID = $('#selected-automatedfollowup').val();

            //check if the activity has been saved to get the activity id else save the operation and get the activity id.
            if ($scope.activity.id == null) {
                //save the activity and get the id
                $scope.activity.activityTypeID = $("#select-event").val();
                eventsDataService.saveActivitiesReport($scope.activity).then(function (eventData) {

                    //assign the returned ID to the ID of the activity object.

                    $timeout(function () {
                        $scope.$apply(function () {
                            activityID = eventData.id;
                            $scope.activity.id = eventData.id;
                            firstTimer = $scope.firstTimer;
                            firstTimer.person.eventID = $scope.activity.id;

                            if (eventData.id = ! null) {

                                membershipdataservices.SaveFirstTimer(firstTimer.person).then(function (result) {

                                    notificationFactory.success("First Timer " + result.name + " successfully saved");
                                    firstTimer.id = result.firstTimerID;
                                    firstTimer.personID = result.id;

                                    $scope.activity.firstTimers.push(firstTimer);


                                    $scope.firstTimer = {};

                                    $("#select-gender").select2("val", '-1');
                                    $("#select-maritalStatus").select2("val", '');
                                    $('#selected-automatedfollowup').select2("val", '-1');

                                },
                                  function () {
                                      notificationFactory.error('Could not save first timer, please check the internet and try again.');
                                  });
                            } else {
                                //no activity id
                            }


                        });

                    }, 0);


                }, function () {
                    notificationFactory.error("Please to continue ensure that you have selected event category and entered activity date ");
                    return;
                });

            } else {
                //This is when the data has been saved.
                $timeout(function () {
                    $scope.$apply(function () {

                        //  $scope.activity.id = eventData.id;
                        firstTimer = $scope.firstTimer;
                        firstTimer.person.eventID = $scope.activity.id;

                        firstTimer.person.eventID = activityID;

                        if ($scope.activity.id = ! null) {


                            membershipdataservices.SaveFirstTimer(firstTimer.person).then(function (result) {

                                notificationFactory.success("First Timer " + result.name + " successfully saved");
                                firstTimer.id = result.firstTimerID;
                                firstTimer.personID = result.id;

                                $scope.activity.firstTimers.push(firstTimer);


                                $scope.firstTimer = {};

                                $("#select-gender").select2("val", '-1');
                                $("#select-maritalStatus").select2("val", '');
                                //   $("#select-event").select2("val", '-1');
                                $('#selected-automatedfollowup').select2("val", '-1');

                            },
                              function () {
                                  notificationFactory.error('Could not save first timer, please check the internet and try again.');
                              });
                        } else {
                            //no activity id
                        }
                    });

                }, 0);

            }

        }

        //This function adds the new converts to the syste
        $scope.AddConverts = function () {

            var membersID = $('#select-newconvert').select2('val');
            dataservices.getPeopleInformation(membersID.toString()).then(function (result) {

                $.each(result, function (i, returnedPerson) {
                    var convert = {};
                    var person = {};

                    person.id = returnedPerson.id;
                    person.name = returnedPerson.firstName + " " + returnedPerson.lastName;
                    person.email = returnedPerson.email;
                    person.phone = returnedPerson.mobilePhone;

                    convert.person = person;
                    convert.activityID = activityID;
                    $scope.activity.converts.push(convert);
                    $('#personselect').val('');

                })
            }, function () {
                notificationFactory.error("Unsuccessful Operation");

            });


        }

        $scope.RemoveAttendance = function (attendance) {

            if (confirm('you are about to remove the attendance entry')) {

                if (attendance.id == null || attendance.id == '') {
                    $scope.activity.attendances.splice($scope.activity.attendances.indexOf(attendance), 1);
                    notificationFactory.success();
                } else {

                    eventsDataService.removeAttendanceData(attendance.id).then(function (r) {//still to test this function
                        $scope.activity.attendances.splice($scope.activity.attendances.indexOf(attendance), 1);
                        notificationFactory.success();
                        $scope.totalAttendance = $scope.activity.attendances.sum('number');

                    }, function (r) {

                        notificationFactory.error(r);
                    });
                }
                $scope.totalAttendance = $scope.activity.attendances.sum('number');
            }
        }

        //This function deletes the first timer information from the system.
        $scope.RemoveFirstTimer = function (firstTimer) {
            if (confirm('you are about to remove the first timer entry')) {

                if (firstTimer.id == null || firstTimer.id == '') {
                    $scope.activity.firstTimers.splice($scope.activity.firstTimers.indexOf(firstTimer), 1);
                    notificationFactory.success();
                } else {
                    eventsDataService.removeFirstTimerData(firstTimer).then(function (r) {//still to test this function
                        $scope.activity.firstTimers.splice($scope.activity.firstTimers.indexOf(firstTimer), 1);
                        notificationFactory.success();
                    }, function (r) {

                        notificationFactory.error(r);
                    });
                }
            }

        }


        //This function deletes the converts information from the system.
        $scope.RemoveConvert = function (convert) {
            if (confirm('you are about to remove the new convert entry')) {

                if (convert.id == null || convert.id == '') {
                    $scope.activity.converts.splice($scope.activity.converts.indexOf(convert), 1);
                    notificationFactory.success();
                } else {
                    eventsDataService.removeConvertData(convert).then(function (r) {//still to test this function
                        $scope.activity.converts.splice($scope.activity.converts.indexOf(convert), 1);
                        notificationFactory.success();
                    }, function (r) {

                        notificationFactory.error(r);
                    });
                }
            }

        }

        function activate() { }



        $scope.UpdateAllFirstTimerSelection = function (peopleArray, firstTimerSelectionValue) {

            for (var i = 0; i < peopleArray.length; i++) {
                peopleArray[i].isSelected = firstTimerSelectionValue;
            }
        }

        $scope.UpdateAllNewConvertSelection = function (peopleArray, newConvertSelectionValue) {

            for (var i = 0; i < peopleArray.length; i++) {
                peopleArray[i].isSelected = newConvertSelectionValue;
            }
        }


        var firstTimers = $scope.activity.firstTimers;


        //This function saves and changees the location to the list page.
        $scope.SaveReport = function () {

            $scope.activity.eventID = $("#select-event").val();

            if (activityID != null) {
                $scope.activity.id = activityID;
            }
            else {
                $scope.activity.id = null;

            }
            eventsDataService.saveCommitActivitiesReport($scope.activity).then(function (eventData) {

                $window.location = '#/Events/EventReports';

            }, function () {

                notificationFactory.error('Could save activity report, please check internet and ensure that event is selected and try again.');
            });
        }


        $('#select-newconvert').select2({
            placeholder: 'Select Person',
            multiple: true,
            minimumInputLength: 3,
            query: function (query) {
                dataservices.getPersonSearch(query.term).then(function (data) {

                    query.callback({ results: data });

                    // return data;
                }, function () { });
            },
            width: "100%"
        });

        $(".datepicker").datepicker({
            showOtherMonths: true
        });
        $("#select-maritalStatus").select2({
            placeholder: 'Marital Status',
            width: "100%"
        });
        $("#select-gender").select2({
            placeholder: 'Gender',
            width: "100%"
        })
    }
})();
