﻿(function () {
    'use strict';

    var controllerId = 'eventsController';

    // TODO: replace app with your module name
    churchplusapp.controller(controllerId,
        ['$scope', 'eventsDataService', 'notificationFactory', eventsController]);

    function eventsController($scope, eventsDataService, notificationFactory) {
        $scope.title = 'eventsController';
        $scope.activate = activate;
        $scope.data = eventsDataService;

        if (eventsDataService.IsEventsDataInitialised() == false) {
            eventsDataService.getEventsData().then(function () { }, function () {
                //display message about internet connection
                notificationFactory.error('Could not retrieve data, please check internet connection and try again');
            });
        }

        $scope.Refresh = function () {
            eventsDataService.getEventsData().then(function () {
                //Success do nothing the data will be picked from the eventdataService factory
            }, function () {
                notificationFactory.error('Could not retrieve data, please check internet connection and try again');
            });
        }



        $scope.Remove = function (eventData) {
            if (confirm('You are about to delete this event and associated data')) {
                eventsDataService.removeEventData(eventData).then(function () {
                    //success call
                    notificationFactory.success('Event successfully removed from the system');
                }, function () {

                    //success call
                    notificationFactory.error('Failure in delete, check the internet connection and try again');

                });
            }
        }
        //Load Events
        function activate() { }

    }
})();
