(function() {
    'use strict';
    angular.module('churchplusapp')
        .factory('financialTransactionDataService', ['$http', '$q',
            function($http, $q) {

                var service = {};
                var apiPrefix = "api/AccountingFinancialController/";

                service.getAll = function() {
                    var deferred = $q.defer();
                    $http({
                        method: 'get',
                        url: apiPrefix + 'GetFinancialTransactions'
                    }).then(function(result) {
                        deferred.resolve(result.data);
                    }, function() {
                        deferred.reject();
                    });
                    return deferred.promise;
                };

                service.delete = function(dataId) { 
                    var deferred = $q.defer();
                    $http({
                        method: 'delete',
                        url: apiPrefix + 'DeleteFinancialTransaction',
                        params: {
                            id: dataId
                        }
                    }).then(function(result) {
                        deferred.resolve(result.data);
                    }, function() {
                        deferred.reject();
                    });
                    return deferred.promise;
                };

                //////////////////////////
                return service;
            }
        ]);
})();