(function() {
    'use strict';
    angular.module('churchplusapp')
        .controller('financialAccountManagementcontroller', ['$scope', 'accountingDataServices', 'notificationFactory',
            function($scope, accountingDataServices, notificationFactory) {

                $scope.data = accountingDataServices;
                var loadData = function() {
                    //call the service to return all the accounts
                    if (accountingDataServices.IsChartOfAccountDataInitialised() == false) {
                        accountingDataServices.getChartOfAccountsData()
                            .then(function(result) {
                                console.log(result);
                            }, function() {
                                notificationFactory.error('Could NOT load data...');
                            });
                    }
                };
                
                $scope.remove = function(contribution) {
                    console.log(contribution);
                    if (confirm('You are about to delete contribution[offering Category]')) {
                        accountingDataServices.removeContributionCategoryData(contribution)
                            .then(function(result) {
                                notificationFactory.success('contribution removed');
                            }, function(result) {
                                notificationFactory.error(result + "The offering types might have offerings attached to it.");
                            });
                    }
                };
				
				loadData();
            }
        ]);
})();