(function() {
    'use strict';
    // TODO: replace app with your module name
    churchplusapp.controller('financialContributionAddEditController', ['$scope', 'accountingDataServices', 'notificationFactory', '$window', '$routeParams', financialContributionAddEditController]);

    function financialContributionAddEditController($scope, accountingDataServices, notificationFactory, $window, $routeParams) {
        var contribution = {};

        $scope.title = 'financialContributionAddEditController';
        $scope.activate = activate;
        $scope.contribution = contribution;;
        $scope.SaveContributionCategory = SaveContributionCategory;

        //load the income accounts
        accountingDataServices.getIncomeAccountsData().then(function(incomeAccount) {
            $("#select-incomeAccount").select2({
                placeHolder: '--select Income Account--',
                data: incomeAccount,
                width: "100%"
            });
        }, function() {});

        //load the cash accounts
        accountingDataServices.getAssetAccountsData().then(function (cashAccount) {
            $("#select-cashAccount").select2({
                placeHolder: '--select cash Account--',
                data: cashAccount,
                width: "100%"
            });
        }, function() {});

        function SaveContributionCategory() {
            //check if the cashaccount is selected
            var incomeID = $("#select-incomeAccount").val();

            if (incomeID == null || incomeID == "") {
                notificationFactory.error('You have to select the income account the money will be put into');
                return;
            } else {
                $scope.contribution.incomeAccountID = incomeID
            }


            //check if the incomeaccount is selected
            var cashID = $("#select-cashAccount").val();
            if (cashID == null || cashID == "") {
                notificationFactory.error('You have to select the cash or Bank account');
                return;
            } else {
                $scope.contribution.cashAccountID = cashID
            }

            //if it is an edit and not an add pass the 'id' to the api
            if ($routeParams.id != null || $routeParams.id != undefined) {
                $scope.contribution.id = $routeParams.id;
            }
            
            accountingDataServices.saveContributionCategory($scope.contribution).then(function(result) {
                if (result.id != "00000000-0000-0000-0000-000000000000") {
                    window.location = "#/Accounting/OfferingCategories";
                } else {
                    notificationFactory.error('Operation was not successful, please ensure that the entries are correct, your session is active and connected to the internet.');
                }
            }, function() {
                notificationFactory.error('Operation was not successful, please ensure that the entries are correct, your session is active and connected to the internet.');
            });
        }

        //when an offering category is clicked
        if ($routeParams.id != null || $routeParams.id != undefined) {
            accountingDataServices.getSingleContributionAccountsData($routeParams.id).then(function (result) {
                //Return the form values of to be edited
                $scope.contribution.name = result.name;
                $("#select-incomeAccount").select2('val', result.incomeAccountID);
                $("#select-cashAccount").select2('val', result.cashAccountID);
                $scope.contribution.isPublic = result.isPublic;
            }, function () { });
        }


        function activate() {}
    }
})();