﻿(function () {
    'use strict';

    var controllerId = 'financialContributionTransactionscontroller';

    // TODO: replace app with your module name
    churchplusapp.controller(controllerId,
        ['$scope', 'accountingDataServices', 'dataservices', '$timeout', 'notificationFactory', financialContributionTransactionscontroller]);

    function financialContributionTransactionscontroller($scope, accountingDataServices, dataservices, $timeout, notificationFactory) {
        var contributionTransaction = {};

        $scope.title = 'financialContributionTransactionscontroller';
        $scope.activate = activate;
        $scope.SaveContributionTransaction = SaveContributionTransaction;
        $scope.contributionTransactions = [];

        $scope.contributionTransaction = contributionTransaction;
        Array.prototype.sum = function (prop) {
            var total = 0
            for (var i = 0, _len = this.length; i < _len; i++) {
                total += this[i][prop]
            }
            return total
        }


        accountingDataServices.getContributionAccountsData().then(function (result) {

            var offerings = [];


            for (var i = 0; i < result.length; i++) {

                var offering = { id: result[i].id, text: result[i].name };
                offerings.push(offering);
            }

            $("#select-contribution").select2({
                placeholder: 'Select Offering Category',
                data: offerings,
                width: "100%"
            })
        }, function () { });


        dataservices.getAllRecentEventDetails().then(function (events) {
            $("#select-event").select2({
                placeholder: 'Select From Events and Activities',
                data: events,
                width: "100%"
            })

        }, function () {
            //Error
            notificationFactory.error('Could not load events data from the server. please check your internet connection.');
        });


        //This method saves the contribution Transaction

        function SaveContributionTransaction() {
            //check if the 
            if ($scope.contributionTransaction.Amount == "") {
                notificationFactory.error('You have to enter a valid amount ')
                return;
            }
            if ($('#select-event').val() == "") {
                notificationFactory.error('You have select the offering category')
                return;
            }
            $scope.contributionTransaction.ActivityID = $('#select-event').val();
            $scope.contributionTransaction.FinancialContributionID = $('#select-contribution').val();
            $scope.contributionTransaction.personID = $('#select-individual-contact').val();

            accountingDataServices.saveContributionTransaction($scope.contributionTransaction).then(function (result) {
                //successful
                //clear the fields and add to the collection.
                if (result.status == true) {
                    $scope.contributionTransactions.push(result.returnObject);
                    notificationFactory.success("The offering saved successfully");
                    $scope.totalAmount = $scope.contributionTransactions.sum('amount');
                    $scope.contributionTransaction = {};
                  
                } else {
                    notificationFactory.error(result.Responce+" Operation was not successful, refresh your browser and try again");

                }

            }, function () {
                notificationFactory.error("Operation was not successful, refresh your browser and try again");


            });


        }

        $timeout(function () {

            $('#select-individual-contact')
        .select2({
            placeholder: 'Select person from membership database',
            multiple: true,
            minimumInputLength: 3,
            query: function (query) {
                dataservices.getPersonSearch(query.term).then(function (data) {

                    query.callback({ results: data });

                    // return data;
                }, function () { });
            },
            width: "100%"
        }
        );

        }, 100);



        function activate() { }
        $(".datepicker").datepicker({
            showOtherMonths: true
        });

        function activate() { }
    }
})();
