(function() {
    'use strict';
    angular.module('churchplusapp')
        .factory('financialContributionDataService', ['$http', '$q',
            function($http, $q) {

                var service = {};
                var apiPrefix = "api/AccountingFinancialController/";

                service.getAll = function() {
                    var deferred = $q.defer();
                    $http({
                        method: 'get',
                        url: apiPrefix + 'GetFinancialOfferingContributionTransactions'
                    }).then(function(result) {
                        deferred.resolve(result.data);
                    }, function() {
                        deferred.reject();
                    });
                    return deferred.promise;
                };

                service.delete = function(dataId) {
                    var deferred = $q.defer();
                    $http({
                        method: 'delete',
                        url: apiPrefix + 'DeleteFinancialContributionTransaction',
                        params: {
                            id: dataId
                        }
                    }).then(function(result) {
                        deferred.resolve(result.data);
                    }, function() {
                        deferred.reject();
                    });
                    return deferred.promise;
                };
				
                //////////////////////////
                return service;
            }
        ]);
})();