(function() {
    'use strict';
    angular.module('churchplusapp')
        .controller('financialAccountCtrl', ['$scope', '$window', 'financialAccountDataService', 'financialFundDataService', 'notificationFactory',
            function($scope, $window, financialAccountDataService, financialFundDataService, notificationFactory) {

                $scope.financialAccountData = [];
                $scope.financialAccountAdd = {};
                $scope.fundList = [];

                $(document).ready(function() {
                    $("#account-type-select").select2(
                        //{placeholder: "Select a state", allowClear: true}
                    );
                    $("#fund-select").select2();
                });

                ///================================================
                //$scope.financialAccountAdd.accountType = $("#account-type-select").val();
                //$scope.financialAccountAdd.fund = $("#fund-select").val();
                //console.log($scope.financialAccountAdd);

                var loadData = function() {
                    financialAccountDataService.getAll()
                        .then(function(result) {
                            $scope.financialAccountData = result;
                        }, function() {
                            notificationFactory.error('Data Loading NOT successfull!');
                        });
                };

                var loadSingleData = function(id) {
                    financialAccountDataService.getById(id)
                        .then(function(result) {
                            $scope.financialAccountDataSingle = result;
                        }, function() {
                            notificationFactory.error('Data Loading NOT successfull!');
                        });
                };

                var loadFundList = function() {
                    financialFundDataService.getAll()
                        .then(function(result) {
                            $scope.fundList = result;
					//	console.log(result);
                        }, function() {
                            notificationFactory.error('Data Loading NOT successfull!');
                        });
                };

                $scope.save = function() {
                    financialAccountDataService.save($scope.financialAccountAdd)
                        .then(function(result) {
                            notificationFactory.success('Saved successfully');
                            $scope.financialAccountData.unshift(result);
                            $window.location.reload();
                        }, function() {
                            notificationFactory.error('Save NOT successfull!');
                        });
                };

                $scope.remove = function(id, index) {
                    console.log(id);
                    if (confirm("Do you want to delete the record?")) {
                        financialAccountDataService.delete(id)
                            .then(function(result) {
                                notificationFactory.success('Deleted successfully');
                                $scope.financialAccountData.splice(index, 1);
                                $window.location.reload();
                            }, function() {
                                notificationFactory.error('Delete NOT successfull!');
                            });
                    }
                };
                loadData();
				loadFundList();
            }
        ]);
})();