(function() {
    'use strict';
    angular.module('churchplusapp')
        .factory('financialFundDataService', ['$http', '$q',
            function($http, $q) {

                var service = {};
                var apiPrefix = "api/AccountingFinancialController/";

                var _financialFundData = []
                service.financialFundData = _financialFundData;

                service.getAll = function() {
                    var deferred = $q.defer();
                    $http({
                        method: 'get',
                        url: apiPrefix + 'GetFinancialFunds'
                    }).then(function(result) {
                        deferred.resolve(result.data);
                    }, function() {
                        deferred.reject();
                    });
                    return deferred.promise;
                };

                service.getById = function(dataId) {
                    var deferred = $q.defer();
                    $http({
                        method: 'get',
                        url: apiPrefix + 'GetSingleFinancialFund',
                        params: {
                            ID: dataId
                        }
                    }).then(function(result) {
                        deferred.resolve(result.data);
                    }, function() {
                        deferred.reject();
                    });
                    return deferred.promise;
                };

                service.save = function(dataToSave) {
                    var deferred = $q.defer();
                    $http({
                        method: 'post',
                        url: apiPrefix + 'SaveFinancialFund',
                        data: dataToSave
                    }).then(function(result) {

                        deferred.resolve(result.data);
                    }, function() {
                        deferred.reject();
                    });
                    return deferred.promise;
                };

                service.delete = function(dataId) {
                    var deferred = $q.defer();
                    $http({
                        method: 'delete',
                        url: apiPrefix + 'DeleteFinancialFund',
                        params: {
                            id: dataId
                        }
                    }).then(function(result) {
                        deferred.resolve(result.data);
                    }, function() {
                        deferred.reject();
                    });
                    return deferred.promise;
                };
                //////////////////////////
                return service;
            }
        ]);
})();