(function() {
    'use strict';
    angular.module('churchplusapp')
        .factory('financialGeneralLedgerDataService', ['$http', '$q',
            function($http, $q) {

                var service = {};
                var apiPrefix = "api/AccountingFinancialController/";

                service.getAll = function() {
                    var deferred = $q.defer();
                    $http({
                        method: 'get',
                        url: apiPrefix + ''
                    }).then(function(result) {
                        deferred.resolve(result.data);
                    }, function() {
                        deferred.reject();
                    });
                    return deferred.promise;
                };
				
                service.getTransactionalAccounts = function() {
                    var deferred = $q.defer();
                    $http({
                        method: 'get',
                        url: apiPrefix + 'GetTransactionalAccounts'
                    }).then(function(result) {
                        deferred.resolve(result.data);
                    }, function() {
                        deferred.reject();
                    });
                    return deferred.promise;
                };

                service.getById = function(dataId) {
                    var deferred = $q.defer();
                    $http({
                        method: 'get',
                        url: apiPrefix + '',
                        params: {
                            ID: dataId
                        }
                    }).then(function(result) {
                        deferred.resolve(result.data);
                    }, function() {
                        deferred.reject();
                    });
                    return deferred.promise;
                };

                service.save = function(dataToSave) {
                    var deferred = $q.defer();
                    $http({
                        method: 'post',
                        url: apiPrefix + 'SaveGeneralLedgerTransaction',
                        data: dataToSave
                    }).then(function(result) {

                        deferred.resolve(result.data);
                    }, function() {
                        deferred.reject();
                    });
                    return deferred.promise;
                };

                service.delete = function(dataId) {
                    var deferred = $q.defer();
                    $http({
                        method: 'delete',
                        url: apiPrefix + '',
                        params: {
                            id: dataId
                        }
                    }).then(function(result) {
                        deferred.resolve(result.data);
                    }, function() {
                        deferred.reject();
                    });
                    return deferred.promise;
                };
                //////////////////////////
                return service;
            }
        ]);
})();