(function() {
    'use strict';
    angular.module('churchplusapp')
        .controller('financialGeneralLedgerCtrl', ['$scope', '$timeout', '$window', 'financialGeneralLedgerDataService', 'financialFundDataService', 'notificationFactory',
            function($scope, $timeout, $window, financialGeneralLedgerDataService, financialFundDataService, notificationFactory) {

                $(".datepicker").datepicker({
                    showOtherMonths: true
                });

                $scope.financialLedgerData2 = [];
                $scope.financialLedgerDataAdd = {};

                $scope.financialFundListData = [];
                $scope.financialAccountListData = [];

                $scope.financialDebitTotal = 0;
                $scope.financialCreditTotal = 0;

                //$scope.financialLedgerAdd.FundSelect = null;
                $scope.fundSelectEnabled = true;
                $scope.fundValueBind = {};

                var loadData = function() {
                    financialGeneralLedgerDataService.getAll()
                        .then(function(result) {}, function() {
                            notificationFactory.error('Data Loading NOT successfull!');
                        });
                };

                $scope.addLedgerToList = function(a) {
                    function removeCommas(valueWithComma) {
                        return valueWithComma.toString().replace(/\,/g, '');
                    };

                    if (a) {
                        var data = {
                            "memo": a.memo || null,
                            "date": a.date || null,
                            "financialAccountID": ((a.AccountSelect != null) ? a.AccountSelect.id : null),
                            "financialFundID": ((a.FundSelect != null) ? a.FundSelect.id : null),
                            "debitAmount": a.debitAmount || 0,
                            "fundName": ((a.FundSelect != null) ? a.FundSelect.name : null),
                            "creditAmount": a.creditAmount || 0,
                            "accountText": ((a.AccountSelect != null) ? a.AccountSelect.text : null),
                        };

                        $scope.financialLedgerData2.push(data);

                        $scope.financialLedgerAdd = {};
                        $scope.financialLedgerAdd.date = a.date;
                        $scope.financialLedgerAdd.memo = a.memo;

                        // BIND FUND VALUE ON FIRST ADD TO LIST
                        if ((a.FundSelect != null) && (a.FundSelect != undefined)) {
                            $scope.fundValueBind = (((a.FundSelect != null) && (a.FundSelect != {})) ? a.FundSelect : {});
                            $scope.financialLedgerAdd.FundSelect = $scope.fundValueBind;
                            $scope.fundSelectEnabled = false;
                        }
                        $scope.financialLedgerAdd.FundSelect = $scope.fundValueBind;
                        $scope.enableSubmitVerify('amount_balance');
                    }
                };

                $scope.save = function() {
                    var data = $scope.financialLedgerData2;
                    financialGeneralLedgerDataService.save(data)
                        .then(function(result) {
                            notificationFactory.success('Successfully saved!');

                            $scope.financialLedgerAdd = {};
                            $scope.financialLedgerData2 = [];
                            $scope.financialLedgerAdd.FundSelect = $scope.fundValueBind;

                        }, function() {
                            notificationFactory.error('Data Loading NOT successfull!');
                        });
                };

                var loadFundListData = function() {
                    financialFundDataService.getAll()
                        .then(function(result) {
                            $scope.financialFundListData = result;
                        }, function() {
                            notificationFactory.error('Data Loading NOT successfull!');
                        });
                };

                var loadAccountListData = function() {
                    financialGeneralLedgerDataService.getTransactionalAccounts()
                        .then(function(result) {
                            $scope.financialAccountListData = result;
                        }, function() {
                            notificationFactory.error('Data Loading NOT successfull!');
                        });
                };

                $scope.remove = function(index) {
                    $scope.financialLedgerData2.splice(index, 1);
                };

                $scope.hideShowFundVal = true;
                $scope.hideShowFund = function(selected) {
                    var val = true;
                    if (selected) val = !((selected.accoutType.toLowerCase() == "expense") || (selected.accoutType.toLowerCase() == "income"));
                    //if (!val) $scope.financialLedgerAdd.FundSelect = null;
                    $scope.hideShowFundVal = val;
                };

                function addCommasToNumber(x) {
                    x = x.toString().replace(/\,/g, ''); // REMOVE EXISTING COMMAS
                    var parts = x.toString().split(".");
                    parts[0] = parts[0].replace(/\B(?=(\d{3})+(?!\d))/g, ",");
                    return parts.join(".");
                };

                $scope.addCommasToNumberVal = function(val) {
                    return addCommasToNumber(val)
                }

                function removeCommas_XXXXXXXXXXXX(valueWithComma) {
                    return valueWithComma.toString().replace(/\,/g, '');
                };

                $scope.enableSubmitVerify = function(check) {
                    var valid = false,
                        data = $scope.financialLedgerData2;

                    function getTotal(fType) {
                        var total = 0;

                        for (var i = 0; data.length > i; i++) {
                            // REMOVE COMMAS
                            var amtDr = (data[i].debitAmount).toString().replace(/\,/g, ''),
                                amtCr = (data[i].creditAmount).toString().replace(/\,/g, '');

                            if (fType == 'debit') total += parseFloat(amtDr) || 0;
                            if (fType == 'credit') total += parseFloat(amtCr) || 0;
                        }
                        return total;
                    };
                    var valDebit = parseFloat(getTotal('debit')),
                        valCredit = parseFloat(getTotal('credit'));

                    if (check == 'amount_balance') {
                        $scope.financialDebitTotal = valDebit;
                        $scope.financialCreditTotal = valCredit;
                    }

                    valid = ((valCredit == valDebit) && (valDebit > 0));

                    var remBalance = 0;

                    if ((valCredit != valDebit) && (check == 'amount_balance')) {
                        remBalance = valCredit - valDebit;
                        if (remBalance < 0)
                            remBalance = (remBalance * -1);

                        if (valCredit > valDebit) {
                            $scope.financialLedgerAdd.debitAmount = addCommasToNumber(remBalance);
                        } else {
                            $scope.financialLedgerAdd.creditAmount = addCommasToNumber(remBalance);
                            
                            // TODO
                            // DECIMAL PLACES
                            //parseFloat(Math.round(num3 * 100) / 100).toFixed(2)
                        }
                    }
                    return valid;
                };

                function loadOnRun() {
                    //loadData();
                    loadFundListData();
                    loadAccountListData();
                };

                loadOnRun();
            }
        ]);
})();