(function() {
    'use strict';
    angular.module('churchplusapp')
        .controller('financialOtherIncomeCtrl', ['$scope', '$window', 'financialFundDataService', 'accountingDataServices', 'notificationFactory',
            function($scope, $window, financialFundDataService, accountingDataServices, notificationFactory) {

                $scope.otherIncomeAdd = {};
                $scope.incomeAccountList = [];
                $scope.cashBankAccountList = [];

                var loadList = function() {
                    accountingDataServices.getIncomeAccountsData()
                        .then(function(result) {
                            $scope.incomeAccountList = result;
                        }, function() {
                            notificationFactory.error('Data Loading NOT successfull!');
                        });

                    accountingDataServices.getAssetAccountsData()
                        .then(function(result) {
                            $scope.cashBankAccountList = result;
                        }, function() {
                            notificationFactory.error('Data Loading NOT successfull!');
                        });
                };

                $scope.save = function() {
                    accountingDataServices.saveOtherIncomeTransaction($scope.otherIncomeAdd)
                        .then(function(result) {
                            notificationFactory.success('Saved successfully');
                        }, function() {
                            notificationFactory.error('Save NOT successfull!');
                        });
                };

                $(".datepicker").datepicker({
                    showOtherMonths: true
                });
                $('#Financial_OtherIncome_modal').on('shown.bs.modal', function(e) {
                    // loadList data when modal opens
                    loadList();
                })
            }
        ]);
})();