(function() {
    'use strict';
    angular.module('churchplusapp')
        .controller('financialTransactionCtrl', ['$scope', '$timeout', '$window', 'financialTransactionDataService', 'notificationFactory',
            function($scope, $timeout, $window, financialTransactionDataService, notificationFactory) {

                $scope.financialTransactionData = [];

                var loadData = function() {
                    financialTransactionDataService.getAll()
                        .then(function(result) {
                            $scope.financialTransactionData = result;
                           
                        }, function() {
                            notificationFactory.error('Delete NOT successfull!');
                        });
                };

                $scope.remove = function(dataId, index) {
                    if (confirm("Do you want to delete the record?")) {
                        financialTransactionDataService.delete(dataId)
                            .then(function(result) {
                                notificationFactory.success('Deleted successfully!');
							$scope.financialTransactionData.splice(index, 1);
                            }, function() {
                                notificationFactory.error('Delete NOT successfull!');
                            });
                    }
                };

                loadData();
            }
        ]);
})();