(function() {
    'use strict';
    angular.module('churchplusapp')
        .controller('financialContributionCtrl', ['$scope', '$timeout', '$window', 'financialContributionDataService', 'notificationFactory',
            function($scope, $timeout, $window, financialContributionDataService, notificationFactory) {

                $scope.financialContributionData = [];

                var loadData = function() {
                    financialContributionDataService.getAll()
                        .then(function(result) {
                            $scope.financialContributionData = result;
                          //  console.log(result);
                        }, function() {
                            notificationFactory.error('Data Loading NOT successfull!');
                        });
                };

                $scope.remove = function(dataId, index) {
                    if (confirm("Do you want to delete the record?")) {

                        financialContributionDataService.delete(dataId)
                            .then(function(result) {
                                notificationFactory.success('Deleted successfully!');
							$scope.financialContributionData.splice(index, 1);
                            }, function() {
                                notificationFactory.error('Data Loading NOT successfull!');
                            });
                    }
                };

                loadData();

            } //financialTransactionDataService
        ]);
})();