(function() {
    'use strict';
    angular.module('churchplusapp')
        .factory('financialAccountDataService', ['$http', '$q',
            function($http, $q) {

                var service = {};
                var apiPrefix = "api/AccountingFinancialController/";

                /////////////////////////
                service.getAll = function() {
                    var deferred = $q.defer();
                    $http({
                        method: 'get',
                        url: apiPrefix + 'GetChartOfAccounts'
                    }).then(function(result) {
                        deferred.resolve(result.data);
                    }, function() {
                        deferred.reject();
                    });
                    return deferred.promise;
                };

                service.getById = function(dataId) {
                    var deferred = $q.defer();
                    $http({
                        method: 'get',
                        url: apiPrefix + 'GetSingleFinancialAccount',
                        params: {
                            id: dataId
                        }
                    }).then(function(result) {
                        deferred.resolve(result.data);
                    }, function() {
                        deferred.reject();
                    });
                    return deferred.promise;
                };

                service.save = function(dataToSave) {
                    var deferred = $q.defer();
                    $http({
                        method: 'post',
                        url: apiPrefix + 'SaveFinancialAccount',
                        data: dataToSave
                    }).then(function(result) {
                        deferred.resolve(result.data);
                    }, function() {
                        deferred.reject();
                    });
                    return deferred.promise;
                };

                service.delete = function(dataId) {
                    var deferred = $q.defer();
                    $http({
                        method: 'delete',
                        url: apiPrefix + 'DeleteFinancialAccount',
                        params: {
                            id: dataId
                        }
                    }).then(function(result) {
                        deferred.resolve(result.data);
                    }, function() {
                        deferred.reject();
                    });
                    return deferred.promise;
                };
                //////////////////////////
                return service;
            }
        ]);
})();