(function() {
    'use strict';
    angular.module('churchplusapp')
        .controller('financialFundCtrl', ['$scope', '$timeout', '$window', 'financialFundDataService', 'notificationFactory',
            function($scope, $timeout, $window, financialFundDataService, notificationFactory) {

                $scope.financialFundData2 = [];
                $scope.financialFundData = function() {
                    return $scope.financialFundData2;
                }
                $scope.financialFundAdd;

                var loadData = function() {
                    financialFundDataService.getAll()
                        .then(function(result) {
                            $scope.financialFundData2 = result;
                        }, function() {
                            notificationFactory.error('Data Loading NOT successfull!');
                        });
                };

                $scope.loadSingleData = function(id) {
                    financialFundDataService.getById(id)
                        .then(function(result) {
                            $('#Financial_Fund_modal').modal('show');
						
						

                            $scope.financialFundAdd = result;
                        }, function() {
                            notificationFactory.error('Data Loading NOT successfull!');
                        });
                };

                $scope.applyChanges_xxxx = function(dataR) {
                  //  console.log(dataR);
                    $scope.financialFundData2 = [];
                  //  console.log('financialFundData2 = []');
                  //  console.log($scope.financialFundData2);
                    $timeout(function() {
                        $scope.$apply(function() {
                            $scope.financialFundData2.push(dataR);
                        });
                    }, 5000);
                };

                $scope.submitFinancialFund = function() {
                    financialFundDataService.save($scope.financialFundAdd)
                        .then(function(result) {
                            $window.location.reload();
                            notificationFactory.success('Saved successfully');
                        }, function() {
                            notificationFactory.error('Save NOT successfull!');
                        });
                };

                $scope.remove = function(id, index) {
                    if (confirm("Do you want to delete the record?")) {
                        financialFundDataService.delete(id)
                            .then(function(result) {
                                $scope.financialFundData2.splice(index, 1);
                                notificationFactory.success('Deleted successfully');
                                $window.location.reload();
                            }, function() {
                                notificationFactory.error('Delete NOT successfull!');
                            });
                    }
                };
                loadData();
            }
        ]);
})();