﻿(function () {
    'use strict';

    var serviceId = 'followUpDataServices';

    // TODO: replace app with your module name
    churchplusapp.factory(serviceId, ['$http', '$q', followUpDataServices]);

    function followUpDataServices($http, $q) {
        var _feedbacks = [];
        var _members = [];
        var _initFeedbacks = false;

        var service = {

            feedbacks: _feedbacks,
            getFeedbacksData: getFeedbacksData,
            addFeedbackData: addFeedbackData,
            removeFeedbackData: removeFeedbackData,
            IsFeedbackDataInitialized: IsFeedbackDataInitialized,
            getFeedbackDataForEdit: getFeedbackDataForEdit,
            removeFollowUpMemberData: removeFollowUpMemberData

        };

        return service;

        function getFeedbacksData() {
            var deferred = $q.defer();

            $http.get('api/FollowUpController/GetFollowUpsData').then(function (result) {
                //successful call
                angular.copy(result.data, _feedbacks);
                _initFeedbacks = true;

                deferred.resolve();
            },
            function () {
                //error in call
                deferred.reject();
            });
            return deferred.promise;
        }

        function addFeedbackData(feedbackData) {
            var deferred = $q.defer();
            if (feedbackData.id != null) {

                for (var i = 0; i < _feedbacks.length; i++) {

                    if (_feedbacks[i].id == feedbackData.id) {
                        _feedbacks.splice(_feedbacks.indexOf(_feedbacks[i]), 1);

                    }
                }

            }

            $http.post('api/FollowUpController/SaveFollowUp', feedbackData).then(function (result) {
                
                _feedbacks.splice(0, 0, result.data);                

                deferred.resolve(result.data);

            }, function () {
                //Error Function
                //put the entry back to the original state if there is error
                if (feedbackData.id != null) {
                    _feedbacks.splice(0, 0, feedbackData);
                }

                deferred.reject();
            });

            return deferred.promise;
        }


        function removeFeedbackData(feedbackData) {
            var deferred = $q.defer();


            $http({
                method: 'delete',
                url: 'api/FollowUpController/DeleteFollowUp',
                params: { ID: feedbackData.id }
            })
               .then(function (result) {
                   for (var i = 0; _feedbacks.length > i; i++) {
                       if (_feedbacks[i].id === feedbackData.id) {
                           _feedbacks.splice(_feedbacks.indexOf(_feedbacks[i]), 1);
                           break;
                       }

                   }
                   deferred.resolve(result.data);
               },
           function () {
               deferred.reject();
           });

            

            return deferred.promise;
        }

        function IsFeedbackDataInitialized() {
            return _initFeedbacks;
        }

        function getFeedbackDataForEdit(id) {
            var deferred = $q.defer();

            $http({
                method: 'get',
                url: 'api/FollowUpController/GetSingleFollowUpData',
                params: { id: id }
            }).then(function (result) {
                //successful call
               
                deferred.resolve(result.data);
            },
            function () {
                //error in call
                deferred.reject();
            });
            return deferred.promise;
        }

        function removeFollowUpMemberData(followUpMemberData) {            

                var deferred = $q.defer();
                $http({
                    method: 'delete',
                    url: 'api/FollowUpController/DeleteFollowUpTeamMember',
                    params: { id: followUpMemberData.id }
                }).then(function (result) {
                    deferred.resolve(result.data);

                }, function (result) {

                    deferred.reject(result.data);
                });

                return deferred.promise;
        }
    }

})();
