﻿(function () {
    'use strict';

    var controllerId = 'followUpNewEditController';

    // TODO: replace app with your module name
    churchplusapp.controller(controllerId,
        ['$scope', '$window', '$routeParams', 'followUpDataServices', 'dataservices', 'notificationFactory', 'settingDataServices', followUpNewEditController]);

    function followUpNewEditController($scope, $window, $routeParams, followUpDataServices, dataservices, notificationFactory, settingDataServices) {

        $scope.title = 'followUpNewEditController';

        $scope.feedback = { followUpTeam: [] };


        if ($routeParams.id == null) {
            bindContactSearch();
            bindStatusSelect();

        }
        else {
            followUpDataServices.getFeedbackDataForEdit($routeParams.id).then(function (feedback) {

                $scope.feedback = feedback;
                bindContactSearch();
                bindStatusSelect();
            }, function () {
                //Use Toaster Alert Note
                notificationFactory.error("Getting the feedback Information, try again");

            })

        }


        $scope.Save = function () {
            var data = $('#contactSelect').select2('data');
            var statusData = $('#statusSelect').select2('data');

            $scope.feedback.personID = data.id;

            $scope.feedback.followUpStatusID = statusData.id;
            followUpDataServices.addFeedbackData($scope.feedback).then(function (result) {
                $window.location = "#/FollowUpFeedBack"
            }, function () {
                notificationFactory.error("Unsuccessful Operation");

            });
        }

        $scope.Cancel = function () {
            alert('cancel Save');

        }

        $scope.removeTeamMember = function (fm) {

            if (fm.id == null) {
                $scope.feedback.followUpTeam.splice($scope.feedback.followUpTeam.indexOf(fm), 1);
                notificationFactory.success();

            } else {
                followUpDataServices.removeFollowUpMemberData(fm).then(function (r) {
                    $scope.feedback.followUpTeam.splice($scope.feedback.followUpTeam.indexOf(fm), 1);
                    notificationFactory.success();
                }, function (r) {
                    notificationFactory.error(r);
                });
            }
        }


        $scope.AddFollowUpMember = function () {

            var selectMembersID = $('#memberSelect').val();

            dataservices.getPeopleInformation(selectMembersID).then(function (result) {

                $.each(result, function (i, person) {

                    var PersonInFollowUpTeam = {};
                    PersonInFollowUpTeam.person = person;
                    PersonInFollowUpTeam.personID = person.id;
                    PersonInFollowUpTeam.dateJoined = Date.now();
                    PersonInFollowUpTeam.FollowUpFeedbackID = $scope.feedback.id;

                    $scope.feedback.followUpTeam.splice(0, 0, PersonInFollowUpTeam);

                    $('#memberSelect').val('');

                })
            }, function () {
                notificationFactory.error("Unsuccessful Operation");

            });
        }



        $(".datepicker").datepicker({
            showOtherMonths: true
        });

        $('#memberSelect').select2({
            placeholder: 'Select member',
            multiple: true,
            minimumInputLength: 3,
            query: function (query) {
                dataservices.getPersonSearch(query.term).then(function (data) {

                    query.callback({ results: data });

                    // return data;
                }, function () { });
            },
            width: "100%"
        });


        function bindContactSearch() {
            $('#contactSelect')
                  .select2({
                      placeholder: 'Select Contact',
                      multiple: false,
                      minimumInputLength: 3,
                      query: function (query) {
                          dataservices.getPersonSearch(query.term).then(function (data) {
                              query.callback({ results: data });
                          }, function () { });
                      },
                      width: "100%",
                      initSelection: function (element, callback) {
                          var returnContact = $scope.feedback.person;

                          if (returnContact != null) {
                              callback({
                                  id: returnContact.id,
                                  text: returnContact.firstName
                              });

                          }
                      }
                  }).select2('val', []);
        }


        function getFollowUpStatus() {
            var options = [];
            settingDataServices.getAllFollowUpStatusSettingData().then(
                function () {
                    var data = settingDataServices.followUpStatusSettingData;
                    for (var i = 0; i < data.length; i++) {
                        options.push({ id: data[i].id, text: data[i].name });
                    }
                },
                function () { })
            return options;
        }

        function bindStatusSelect() {
            $('#statusSelect')
                  .select2({
                      placeholder: 'Select Status',
                      multiple: false,
                      data: getFollowUpStatus(),
                      width: "100%",
                      initSelection: function (element, callback) {
                          var returnContact = $scope.feedback.followUpStatus;

                          if (returnContact != null) {
                              callback({
                                  id: returnContact.id,
                                  text: returnContact.name
                              });

                          }
                      }
                  }).select2('val', []);
        }


    }

})();
