﻿
(function () {
    'use strict';

    var controllerId = 'followUpStatusSettingController';

    // TODO: replace app with your module name
    churchplusapp.controller(controllerId,
        ['$scope', '$window', 'settingDataServices', 'notificationFactory', 'dataservices', '$filter', 'ngTableParams', followUpStatusSettingController]);


    function followUpStatusSettingController($scope, $window, settingDataServices, notificationFactory, dataservices, $filter, ngTableParams) {

        $scope.settingEdit = {};
        $scope.settingAdd = {};
        $scope.data = settingDataServices.followUpStatusSettingData;

        if (settingDataServices.isFollowUpStatusSettingDataInitialized() == false) {

            //@ Get Data
            settingDataServices.getAllFollowUpStatusSettingData()
                .then(function () {
                    //@ Success  

                },
         function () {
             //@ Failure
             notificationFactory.error('Error loading data...');
         });
        }

        //Refresh Data
        $scope.Refresh = function () {
            settingDataServices.getAllFollowUpStatusSettingData()
                .then(function () {
                    //@ Success
                    $scope.data = settingDataServices.followUpStatusSettingData;
                },
                function () {
                    //Error refreshing data set
                    notificationFactory.error('Can not retrive data from the server now, please check internet connections and try again');
                });
        }

        $scope.tableParams = new ngTableParams({
            count: $scope.data.length
        }, {
            counts: []
        });

        $scope.editId = -1;

        $scope.setEditId = function (pid) {
            findEdit(pid)
            $scope.editId = pid;
        };

        $scope.saveAdd = function () {
            settingDataServices.saveFollowUpStatusSettingData($scope.settingAdd)
            .then(function (result) {
                //@ Success  

                $scope.settingAdd = {};
                notificationFactory.success("Added Successfully");

            }, function () {
                //@ Failure
                notificationFactory.error("Unsuccessful Operation");
            });
        };

        $scope.delete = function (a) {
            settingDataServices.deleteFollowUpStatusSettingData(a)
                .then(function (a) {
                    //@ Success

                    notificationFactory.success(a.id + ' removed');
                }, function (a) {
                    //@ Error

                    notificationFactory.error(a);
                });
        };

        $scope.saveEdit = function () { 
            settingDataServices.saveFollowUpStatusSettingData($scope.settingEdit)
            .then(function (result) {
                //@ Success  
                notificationFactory.success("Edited Successfully");
                $scope.editId = -1;

            }, function () {
                //@ Failure
                notificationFactory.error("Unsuccessful Operation");
            });
        };

        $scope.cancel = function () {
            $scope.editId = -1;
            $scope.Refresh();
        };

        function findEdit(idx) {
            if (idx != null) {
                for (var i = 0; $scope.data.length > i; i++) {
                    if ($scope.data[i].id === idx) {
                        $scope.settingEdit = $scope.data[i];
                        break;
                    }
                }
            }
        }
    }
})();