﻿(function () {
    'use strict';

    var serviceId = 'groupdataservices';

    // TODO: replace app with your module name
    churchplusapp.factory(serviceId, ['$http', '$q', groupdataservices]);

    function groupdataservices($http, $q) {
        // Define the functions and properties to reveal.

        var _groups = [];
        var _members = [];
        var _events = [];
        var _initGroups = false;

        var service = {

            groups: _groups,
            getGroupsData: getGroupsData,
            addGroupData: addGroupData,
            getGroupsByMemberID:getGroupsByMemberID,
            removeGroupData: removeGroupData,
            IsGroupDataInitialized: IsGroupDataInitialized,
            getGroupDataForEdit: getGroupDataForEdit,
            removeGroupMemberData: removeGroupMemberData


        };

        return service;

        function getGroupsData() {
            var deferred = $q.defer();

            $http.get('/api/GroupsApi').then(function (result) {
                //successful call
               angular.copy(result.data, _groups);
                _initGroups = true;

                deferred.resolve();
            },
            function () {
                //error in call
                deferred.reject();
            });
            return deferred.promise;
        }

        function addGroupData(groupData) {
            var deferred = $q.defer();
            if (groupData.id != null) {

                for (var i = 0; i < _groups.length; i++) {

                    if (_groups[i].id == groupData.id) {
                        _groups.splice(_groups.indexOf(_groups[i]), 1);

                    }
                }

            }

            $http.post('/api/GroupsApi', groupData).then(function (result) {
                //Success Function
                var groupCreated = {};

                groupCreated.id = result.data.id;
                groupCreated.name = result.data.name;
                groupCreated.dateCreated = result.data.dateCreated;

                if (result.data.peopleInGroups == null) {
                    groupCreated.membershipcount = 0;

                } else {
                    groupCreated.membershipcount = result.data.peopleInGroups.length;

                }
                //Massage the data
                _groups.splice(0, 0, groupCreated);

                deferred.resolve(groupCreated);

            }, function (result) {
                //Error Function
                //put the entry back to the original state if there is error
                if (groupData.id != null) {
                    _groups.splice(0, 0, groupData);
                }

                deferred.reject(result);
            });

            return deferred.promise;

        }
        function removeGroupData(groupData) {
            var deferred = $q.defer();

            $http.delete('/api/GroupsApi/' + groupData.id).then(function (result) {
                _groups.splice(_groups.indexOf(groupData), 1);
                deferred.resolve(groupData);

            }, function (result) {

                deferred.reject(result);
            });

            return deferred.promise;

        }
        function getGroupDataForEdit(id) {
            var deferred = $q.defer();

            $http({
                method: 'get',
                url: '/api/GroupsApi/',
                params: { id: id }
            }).then(function (result) {
                //successful call

                deferred.resolve(result.data);
            },
            function () {
                //error in call
                deferred.reject();
            });
            return deferred.promise;

        }
        function getGroupsByMemberID(id)
        {
            var deferred = $q.defer();

            $http({
                method: 'get',
                url: 'api/GroupsController/GroupsBelongToByMember',
                params: { id: id }
            }).then(function (result) {
                //successful call

                deferred.resolve(result.data);
            },
            function () {
                //error in call
                deferred.reject();
            });
            return deferred.promise;
        }
        function removeGroupMemberData(groupMemberData) {

            var deferred = $q.defer();
            $http({
                method: 'delete',
                url: '/api/GroupsController/DeleteGroupMemberData/',
                params: { id: groupMemberData.id }
            }).then(function (result) {
                deferred.resolve(result.data);

            }, function (result) {

                deferred.reject(result.data);
            });

            return deferred.promise;

        }
        function IsGroupDataInitialized() {
            return _initGroups;
        }


    }
})();

        

     