﻿(function () {
    'use strict';

    var controllerId = 'homedashboardcontroller';

    // TODO: replace app with your module name
    churchplusapp.controller(controllerId,
        ['$scope', 'dashboardDataservices', '$timeout', 'membershipdataservices','notificationFactory',homedashboardcontroller]);

    function homedashboardcontroller($scope, dashboardDataservices, $timeout, membershipdataservices, notificationFactory) {
        $scope.title = 'homedashboardcontroller';
        $scope.activate = activate;
        $scope.data = { MembershipEnagement: '-', MembershipSize: '-', firstTimerRetention: '-', NewConvertCount: '-', firstTimersCount: '-' };
        function activate() { }
        DatePickerBinder();

        //The call for first Timers
        dashboardDataservices.getFirstTimerSizeData(null, null).then(function (result) {
            $scope.data.firstTimersCount = result;
        }, function () { });

        dashboardDataservices.getNewConvertSizeData(null, null).then(function (result) {
            $scope.data.NewConvertCount = result;
        }, function () { });

        dashboardDataservices.getRententionData(null, null).then(function (result) {
            $scope.data.firstTimerRetention = result;
        }, function () { });

        dashboardDataservices.getEngagementData(null, null).then(function (result) {
            $scope.data.MembershipEnagement = result;
        }, function () { });

        dashboardDataservices.getMembershipSizeData(null, null).then(function (result) {
            $scope.data.MembershipSize = result;

            if (parseInt(result) <= 5) {
              //  alert(3333);
                //show Modal the message prompting them to add members to the church.
             //   $('#AddMember_modal').show('Modal');
                $timeout(function () {

                    $('#AddMember_modal').modal('show');
                }, 1000);
            }

        }, function () { });

        if (dashboardDataservices.IsGroupChartDataInitialised() == false) {
            dashboardDataservices.getGroupChartData().then(function (result) {

                DrawGroupChart(result);
                //  $("#donut-chart").showMemo();

            }, function () { });
        } else {
            DrawGroupChart(dashboardDataservices.groupChartData);
        }

        if (dashboardDataservices.IsChurchPerformanceDataInitialised() == false) {
            dashboardDataservices.getChurchPerformanceChartData(null, null).then(function (result) {

                DrawChurchPerformance(result)
            }, function () { });
        } else {
            DrawChurchPerformance(dashboardDataservices.churchPerformanceData);
        }
        //call the service to get data for the church performance dashboard.
        if (dashboardDataservices.IsChurchFinancialPerformanceDataInitialised() == false) {
            dashboardDataservices.getChurchFinancialPerformanceChartData(null, null).then(function (result) {

                DrawChurchFinancialPerformance(result)
            }, function () { });
        } else {
            DrawChurchFinancialPerformance(dashboardDataservices.churchFinancialPerformanceData);
        }

        /// The Save Operation for the quick membership Add Function.
           $scope.SaveContact = function () {
            $scope.contactForm.$invalid = true;
            $scope.person.genderID = $("#select-gender").val();
            $scope.person.maritalStatusID = $("#select-maritalStatus").val();

          

            membershipdataservices.SaveMemberInformation($scope.person).then(function () {

                notificationFactory.success("New Contact Information successfully saved; Please add another contact OR close the window");
                $scope.person = {};
                $("#select-gender").select2("val", '-1');
                $("#select-maritalStatus").select2("val", '');
                

            },
             function () {
                 notificationFactory.error('Could not save member information, please check the internet and try again.');


             });

        }





        function DrawChurchPerformance(result) {
            var options = {
                legend: {
                    show: true,
                    margin: 10,
                    backgroundOpacity: 0.9
                },
                points: {
                    show: true,
                    radius: 3
                },
                lines: {
                    show: true,
                    fill: true
                },
                grid: { hoverable: true, clickable: true },
                yaxis: { min: 0, tickFormatter: formatter },
                xaxis: { ticks: [[1, "Jan"], [2, "Feb"], [3, "Mar"], [4, "Apr"], [5, "May"], [6, "Jun"], [7, "Jul"], [8, "Aug"], [9, "Sep"], [10, "Oct"], [11, "Nov"], [12, "Dec"]] }


            };
            function formatter(val, axis) {
                return val.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
            }
            var attendanceDataset = [];
            var firstNewConvertDataset = [];
            attendanceDataset.push(result[2]);
            firstNewConvertDataset.push(result[0]);
            firstNewConvertDataset.push(result[1]);

            $.plot($("#church_performance"), attendanceDataset, options);
            $.plot($("#church_performance2"), firstNewConvertDataset, options);
        }
        function DrawChurchFinancialPerformance(result) {
        
            var options = {
                legend: {
                    show: true,
                    margin: 10,
                    backgroundOpacity: 0.9
                },
                points: {
                    show: true,
                    radius: 3
                },
                series: {
                    shadowSize: 1,
                    bars: {
                        show: true,
                        barWidth: 0.13,
                        order: 1
                    }},

                grid: { hoverable: true, clickable: true },
                yaxis: { min: 0, tickFormatter: formatter },
                xaxis: {
                    ticks: [
                        [1, "Jan"],
                        [2, "Feb"],
                        [3, "Mar"],
                        [4, "Apr"],
                        [5, "May"],
                        [6, "Jun"],
                        [7, "Jul"],
                        [8, "Aug"],
                        [9, "Sep"],
                        [10, "Oct"],
                        [11, "Nov"],
                        [12, "Dec"]
                    ]
                }
            };
            function formatter(val, axis) {
                return val.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
            }
            if (result != null || result[0]!='undefined') {

                $.plot($("#church_financial_performance"), result, options);
            }
        }
        function DatePickerBinder() {
            $('#reportrange').daterangepicker(
               {
                   startDate: moment().subtract('days', 29),
                   endDate: moment(),
                   minDate: '01/01/2012',
                   maxDate: '12/31/2014',
                   dateLimit: { days: 60 },
                   ranges: {
                       'Today': [moment(), moment()],
                       'Yesterday': [moment().subtract('days', 1), moment().subtract('days', 1)],
                       'Last 7 Days': [moment().subtract('days', 6), moment()],
                       'This Month': [moment().startOf('month'), moment().endOf('month')],
                       'Last Month': [moment().subtract('month', 1).startOf('month'), moment().subtract('month', 1).endOf('month')]
                   },
                   opens: 'left',
                   buttonClasses: ['btn'],
                   applyClass: 'btn-small btn-info btn-block',
                   cancelClass: 'btn-small btn-default btn-block',
                   format: 'MM/DD/YYYY',
                   separator: ' to ',
                   locale: {
                       applyLabel: 'Submit',
                       fromLabel: 'From',
                       toLabel: 'To',
                       customRangeLabel: 'Custom Range',
                       daysOfWeek: ['Su', 'Mo', 'Tu', 'We', 'Th', 'Fr', 'Sa'],
                       monthNames: ['January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December'],
                       firstDay: 1
                   }
               },
               function (start, end) {
                   $.jGrowl('A date range was changed', { header: 'Update', position: 'center', life: 1500 });

                   $('#reportrange .date-range').html(start.format('<i>D</i> <b><i>MMM</i> <i>YYYY</i></b>') + '<em> - </em>' + end.format('<i>D</i> <b><i>MMM</i> <i>YYYY</i></b>'));
               }
               );
            $('#reportrange .date-range').html(moment().subtract('days', 29).format('<i>D</i> <b><i>MMM</i> <i>YYYY</i></b>') + '<em> - </em>' + moment().format('<i>D</i> <b><i>MMM</i> <i>YYYY</i></b>'));
            $('#reportrange').on('show', function (ev, picker) {
                $('.range').addClass('range-shown');
            });

            $('#reportrange').on('hide', function (ev, picker) {
                $('.range').removeClass('range-shown');
            });
        }
        function DrawGroupChart(result) {
            var donutData = result;

            $.plot("#donut-chart", donutData, {
                series: {
                    pie: {
                        show: true,
                        radius: 1,
                        innerRadius: 0.5,
                        label: {
                            show: false,
                            radius: 2 / 3,
                            formatter: labelFormatter,
                            //  threshold: 0.3
                        }

                    }
                },
                legend: {
                    show: true
                }, grid: {
                    hoverable: true,
                }
            });
        }
        function labelFormatter(label, series) {
            return "<div style='font-size:13px; text-align:center; padding:2px; color: #fff; font-weight: 600;'>"
                    + label
                    + "<br/>"
                    + Math.round(series.percent) + "%</div>";
        }

    }
})();
