﻿
(function () {
    'use strict';

    var controllerId = 'houseFellowshipNewEditController';

    // TODO: replace app with your module name
    churchplusapp.controller(controllerId,
        ['$scope', '$window', '$routeParams', 'dataservices', '$q', '$filter', 'cellFellowshipDataServices', 'notificationFactory', 'ngTableParams', houseFellowshipNewEditController]);

    function houseFellowshipNewEditController($scope, $window, $routeParams, dataservices, $q, $filter, cellFellowshipDataServices, notificationFactory, ngTableParams) {
        $scope.title = 'houseFellowshipNewEditController';
        $scope.houseFellowship = { peopleInCenter: [] };
        $scope.activities = [];

        if ($routeParams.id) {
            cellFellowshipDataServices.getSingleHouseFellowshipData($routeParams.id)
                .then(function (result) {
                    //@ Success
                    $scope.houseFellowship = result;
                    bindZones();
                    cellFellowshipDataServices.getAllActivityByHouseFellowship($routeParams.id).then(
                        function (result) {
                            $scope.activities = result;                           
                        },
                        function () { }
                        );
                    ngTableFunction();
                },
                function () {
                    //Error refreshing data set
                    notificationFactory.error('Can not retrive data from the server now, please check internet connections and try again');
                });
        }
        else {
            bindZones();
            ngTableFunction();
        }


        //load the email drafts
        $scope.loadEmailTemplates = function () {
            dataservices.getEmailDrafts().then(function (emails) {

                $("#emaildraftselect").select2({
                    placeholder: 'Select From Drafts',
                    data: emails,
                    width: "100%"         //

                }).on("change", function (e) {

                    //call the get email service
                    dataservices.getEmailDraftByID(e.val).then(function (emaildraft) {

                        $scope.emailSubject = emaildraft.subject;
                        $scope.emailMessage = emaildraft.message;
                       $('#emailMessage').val(emaildraft.message);
                      //  $('#emailMessage').data("wysihtml5").editor.setValue(emaildraft.message);


                    }, function () {
                        //error
                        notificationFactory.error("Unsuccessful");

                    });

                });

            }, function () {
                // error
                notificationFactory.error('Could not load saved email drafts from the server. kindly enter email manually.');
            });
        }

        //Load the sms templates
        $scope.loadSMSTemplates = function () {
            dataservices.getSMSDrafts().then(function (sms) {
                $("#smsdraftselect").select2({
                    placeholder: 'Select From SMS Drafts',
                    data: sms,
                    width: "100%"
                }).on("change", function (e) {

                    //call the get email service

                    dataservices.getSMSDraftByID(e.val).then(function (smsdraft) {

                        $scope.smsSubject = smsdraft.sender;
                        $scope.smsMessage = smsdraft.message;

                    }, function () {

                        //Error
                        notificationFactory.error("Unsuccessful");

                    });

                });

            }, function () {

                //Error
                notificationFactory.error('Could not load saved sms drafts from the server. kindly enter email manually.');


            });
        }


        //Send SMS Method, this checks if the client has enough credit before the sms operation is activated.
        $scope.SendSMS = function () {

            if (getSelectedMembers().length < 1) {
                notificationFactory.error('Please select contact to send sms');
            }
            else {
                var messageObject = {};
                messageObject.subject = $scope.smsSubject;
                messageObject.message = $scope.smsMessage;
                messageObject.contacts = getSelectedMembers();
                //check if the client has enough unit to send sms


                //If true then send the sms.
                dataservices.checkBalanceAndSendSMS(messageObject).then(function () {

                    notificationFactory.success('SMS successfully sent');

                }, function () {

                    notificationFactory.error('There was an error sending SMS, please check your internet connection and try again.');

                });
            }


        }

        //Send Email Operation, this calls the base functionality factory dataservices.
        $scope.SendEmail = function () {
            if (getSelectedMembers().length < 1) {
                notificationFactory.error('Please select contact to send email');
            }
            else {
                var messageObject = {};
                messageObject.subject = $scope.emailSubject;
                messageObject.message = $scope.emailMessage;
                messageObject.contacts = getSelectedMembers();
                //post this to the dataservice factory that will serve as the common functionality base.

                dataservices.sendEmails(messageObject).then(function () {
                    notificationFactory.success('Emails successfully sent');
                }, function () {
                    // error
                    notificationFactory.error('There was an error sending email, please check your internet connection and try again.');
                });
            }

        }

        function getSelectedMembers() {
            var MembersArray = [];
            
            
            for (var i = 0; i < $scope.houseFellowship.peopleInCenter.length; i++) {
                if ($scope.houseFellowship.peopleInCenter[i].id in $scope.checkboxes.items)                
                 {
                
                    var houseFellowshipMember = {};

                    houseFellowshipMember.id = $scope.houseFellowship.peopleInCenter[i].person.id;
                    houseFellowshipMember.firstName = $scope.houseFellowship.peopleInCenter[i].person.firstName;
                    houseFellowshipMember.lastName = $scope.houseFellowship.peopleInCenter[i].person.lastName;
                    houseFellowshipMember.mobilePhone = $scope.houseFellowship.peopleInCenter[i].person.mobilePhone;
                    houseFellowshipMember.email = $scope.houseFellowship.peopleInCenter[i].person.email;
                    MembersArray.push(houseFellowshipMember);
                }
            }
            console.log(MembersArray);
            return MembersArray;
        }

        /////////////////function for saving a house fellowship

        $scope.Save = function () {
            $scope.houseFellowship.districtID = $('#select-zone').select2('data').id;
            cellFellowshipDataServices.saveHouseFellowshipData($scope.houseFellowship)
                .then(function (result) {
                    //@ Success  

                    $window.location = "#/HouseFellowship";

                }, function () {
                    //@ Failure
                    notificationFactory.error("Unsuccessful Operation");
                });
        }

        $scope.Goto = function (url) {
            $window.location = url;
        }

       
       

        ////////////////////////ngtable for house fellowship members and house fellowship activities
        function ngTableFunction() {

            $scope.tableParams1 = new ngTableParams({
                page: 1,            // show first page
                count: 10,          // count per page
                sorting: {
                    name: 'asc'     // initial sorting
                }
            }, {
                total: $scope.houseFellowship.peopleInCenter.length, // length of data
                getData: function ($defer, params) {
                    // use build-in angular filter
                    var orderedData = params.sorting() ? $filter('orderBy')($scope.houseFellowship.peopleInCenter, params.orderBy()) : $scope.houseFellowship.peopleInCenter;

                    $defer.resolve(orderedData.slice((params.page() - 1) * params.count(), params.page() * params.count()));
                }
            });

            $scope.tableParams2 = new ngTableParams({
                page: 1,            // show first page
                count: 10,          // count per page
                sorting: {
                    name: 'asc'     // initial sorting
                }
            }, {
                total: $scope.activities.length, // length of data
                getData: function ($defer, params) {
                    // use build-in angular filter
                    var orderedData = params.sorting() ? $filter('orderBy')($scope.activities, params.orderBy()) : $scope.activities;

                    $defer.resolve(orderedData.slice((params.page() - 1) * params.count(), params.page() * params.count()));
                }
            });

        }
        ////////////// select checkboxes
        $scope.checkboxes = { 'checked': false, items: {} };

        // watch for check all checkbox
        $scope.$watch('checkboxes.checked', function (value) {
            angular.forEach($scope.houseFellowship.peopleInCenter, function (item) {
                if (angular.isDefined(item.id)) {
                    $scope.checkboxes.items[item.id] = value;
                }
            });
           
        });

        // watch for data checkboxes
        $scope.$watch('checkboxes.items', function (values) {
            if (!$scope.houseFellowship.peopleInCenter) {
                return;
            }
            var checked = 0, unchecked = 0,
                total = $scope.houseFellowship.peopleInCenter.length;
            angular.forEach($scope.houseFellowship.peopleInCenter, function (item) {
                checked += ($scope.checkboxes.items[item.id]) || 0;
                unchecked += (!$scope.checkboxes.items[item.id]) || 0;
            });
            if ((unchecked == 0) || (checked == 0)) {
                $scope.checkboxes.checked = (checked == total);
            }
            // grayed checkbox
            angular.element(document.getElementById("select_all")).prop("indeterminate", (checked != 0 && unchecked != 0));
        }, true);

        ////////////////////////////// function for deleting house fellowship center member
        $scope.RemoveHouseFellowshipMember = function (member) {
            if (confirm("Are you sure you want to delete this Member from this house fellowship")) {
                if (member.id == null) {
                    $scope.houseFellowship.peopleInCenter.splice($scope.houseFellowship.peopleInCenter.indexOf(member), 1);
                    notificationFactory.success();

                } else {
                    cellFellowshipDataServices.removeHouseFellowshipMemberData(member).then(function (r) {
                        $scope.houseFellowship.peopleInCenter.splice($scope.houseFellowship.peopleInCenter.indexOf(member), 1);
                        notificationFactory.success();
                    }, function (r) {
                        notificationFactory.error(r);
                    });
                }
            }
        }

        ////////////////////////////// function for deleting house fellowship center member
        $scope.RemoveHouseFellowshipActivity = function (activity) {
            if (confirm("Are you sure you want to delete this Report from this house fellowship")) {
                if (activity.id == null) {
                    $scope.activities.splice($scope.activities.indexOf(activity), 1);
                    notificationFactory.success();

                } else {
                    cellFellowshipDataServices.deleteActivityData(activity.id).then(function (r) {
                        $scope.activities.splice($scope.activities.indexOf(activity), 1);
                        notificationFactory.success();
                    }, function (r) {
                        notificationFactory.error(r);
                    });
                }
            }
        }

     

        /////////////////////////// select2 plugin for adding members

        $('#memberSelect').select2({
            placeholder: 'Select member',
            multiple: true,
            minimumInputLength: 3,
            query: function (query) {
                dataservices.getPersonSearch(query.term).then(function (data) {

                    query.callback({ results: data });

                    // return data;
                }, function () { });
            },
            width: "100%"
        });


        $scope.AddHouseFellowshipMember = function () {

            var selectMembersID = $('#memberSelect').val();

            dataservices.getPeopleInformation(selectMembersID).then(function (result) {

                $.each(result, function (i, person) {

                    var PersonInHouseFellowship = {};
                    PersonInHouseFellowship.person = person;
                    PersonInHouseFellowship.personID = person.id;
                    PersonInHouseFellowship.dateJoined = Date.now();
                    PersonInHouseFellowship.cellCenterID = $scope.houseFellowship.id;
                    PersonInHouseFellowship.position = "Member";

                    $scope.houseFellowship.peopleInCenter.splice(0, 0, PersonInHouseFellowship);

                    $('#memberSelect').val('');

                })
            }, function () {
                notificationFactory.error("Unsuccessful Operation");

            });
        }

        /////////////////////////// select2 plugin for zones field


        function getZones() {
            var options = [];
            cellFellowshipDataServices.getAllZoneData().then(
                function () {
                    var data = cellFellowshipDataServices.zoneData;
                    for (var i = 0; i < data.length; i++) {
                        options.push({ id: data[i].id, text: data[i].name });
                    }
                },
                function () { })
            return options;
        }

        function bindZones() {
            $('#select-zone')
                  .select2({
                      placeholder: 'Select Zone',
                      multiple: false,
                      data: getZones(),
                      width: "100%",
                      initSelection: function (element, callback) {
                          var returnDistrict = $scope.houseFellowship.district;                         
                          if (returnDistrict != null) {
                              callback({
                                  id: returnDistrict.id,
                                  text: returnDistrict.name
                              });

                          }
                      }
                  }).select2('val', []);
                  
        }

    }
})();
