(function () {
    'use strict';

    var serviceId = 'mediaDataServices';

    // TODO: replace app with your module name
    churchplusapp.factory(serviceId, ['$http', '$q', mediaDataServices]);

    function mediaDataServices($http, $q) {

        var _mediaData = [];
        var audioData = [];
        var videoData = [];
        var docsData = [];
        var pictureData = [];

        var _mediaTypes = [];

        var _initMediaData = false;

        var service = {
            //mediaData: _mediaData,
            mediaTypes: _mediaTypes,
            audioData: audioData,
            videoData: videoData,
            docsData: docsData,
            pictureData: pictureData,

            getAllMediaData: getAllMediaData,
            getSingleMediaData: getSingleMediaData,
            saveMediaData: saveMediaData,
            deleteMediaData: deleteMediaData,
            isMediaDataInitialized: isMediaDataInitialized,
            getAllMediaTypes: getAllMediaTypes
        };

        return service;


        /////////////////////// function for getting all the media files		

        function getAllMediaData() {
            var deferred = $q.defer();
            if (_initMediaData == false) {
                $http.get('api/MediaController/GetMedia').then(
                    function (result) {
                        //successful call
                        angular.copy(result.data, _mediaData);
                        angular.forEach(_mediaData, function (v, x) {
                            if (v.mediaType == 0) {
                                videoData.push(v);
                            } else if (v.mediaType == 2) {
                                docsData.push(v);
                            } else if (v.mediaType == 1) {
                                audioData.push(v);
                            } else if (v.mediaType == 3) {
                                pictureData.push(v);
                            }
                        });
                        _initMediaData = true;
                        deferred.resolve();
                    },
					function () {
					    //error in call
					    deferred.reject();
					});
            }
            else {
                deferred.resolve();
            }

            return deferred.promise;
        }

        //////////// function for getting a single media file

        function getSingleMediaData(mediaID) {
            var deferred = $q.defer();
            $http({
                method: 'get',
                url: 'api/MediaController/GetSingleMedia',
                params: {
                    id: mediaID
                }
            }).then(function (result) {
                //@ successful call
                deferred.resolve(result.data);
            },
				function () {
				    //@ error in call
				    deferred.reject();
				});
            return deferred.promise;
        }

        //////////////// function for Saving a media file.

        function saveMediaData(mediaToSave) {
            //var deferred = $q.defer();

            $http.post('api/MediaController/SaveMedia', mediaToSave)
            .then(function (result) {
            	if (mediaToSave.id != null) {
            		for (var i = 0; _mediaData.length > i; i++) {
            			if (_mediaData.id === mediaToSave.id) {
            				_mediaData.splice(i, 1, result.data);
            				break;
            			}
            		}
            	} else
            		_mediaData.splice(0, 0, result.data);
            	deferred.resolve(result.data);
            }, function (result) {
            	deferred.reject(result.data);
            });
            //return deferred.promise;
        }

        /////////////////////// function for Deleting media file.

        function deleteMediaData(media) {
            var deferred = $q.defer();
            $http({
                method: 'delete',
                url: 'api/MediaController/DeleteMedia',
                params: {
                    ID: media.id
                }
            })
			.then(function (result) {
			    //remove the deleted item from the local dataset
			    if (result.data.mediaType == 0) {
			        for (var i = 0; videoData.length > i; i++) {
			            if (videoData[i].id == result.data.id) {
			                videoData.splice(i, 1);
			                break;
			            }
			        }
			    }
			    else if (result.data.mediaType == 1) {
			        for (var i = 0; audioData.length > i; i++) {
			            if (audioData[i].id == result.data.id) {
			                audioData.splice(i, 1);
			                break;
			            }
			        }
			    }
			    else if (result.data.mediaType == 2) {
			        for (var i = 0; docsData.length > i; i++) {
			            if (docsData[i].id == result.data.id) {
			                docsData.splice(i, 1);
			                break;
			            }
			        }
			    }
			    else if (result.data.mediaType == 3) {
			        for (var i = 0; pictureData.length > i; i++) {
			            if (pictureData[i].id == result.data.id) {
			                pictureData.splice(i, 1);
			                break;
			            }
			        }
			    }
			    deferred.resolve(result.data);

			}, function (result) {
			    // @ Error
			    deferred.reject(result.data);
			});
            return deferred.promise;
        }

        // Initialization check...

        function isMediaDataInitialized() {
            return _initMediaData;
        }

        function getAllMediaTypes() {
            var deferred = $q.defer();
            $http.get("api/MediaController/getMediaType")
            .then(function (result) {
                angular.copy(result.data, _mediaTypes);
                deferred.resolve();
            },
            function () {
                deferred.reject();
            });
            return deferred.promise;
        }

    }

})();
