﻿/// <reference path="../../announcement/view/announcementNewEditView.html" />

(function () {
    'use strict';

    var controllerId = 'mediaHomeController';

    // TODO: replace app with your module name
    churchplusapp.controller(controllerId,
        ['$scope', '$window', 'mediaDataServices', 'notificationFactory', 'dataservices', mediaHomeController]);

    function mediaHomeController($scope, $window, mediaDataServices, notificationFactory, dataservices) {
        //$scope.mediaFiles = mediaDataServices.mediaData;
        $scope.audioData = mediaDataServices.audioData;
        $scope.videoData = mediaDataServices.videoData;
        $scope.docsData = mediaDataServices.docsData;
        $scope.pictureData = mediaDataServices.pictureData;


        // @ Check Initialization....
        if (mediaDataServices.isMediaDataInitialized() == false) {
            //@ Get Data
            mediaDataServices.getAllMediaData()
                .then(function () {},
                    function () {
                     //@ Failure
                     notificationFactory.error('Error loading data...');
                });
        }

        //////////////////////////////////Refresh Data
        $scope.Refresh = function () {
            mediaDataServices.getAllMediaData()
                .then(function () {
                    //@ Success
                },
                function () {
                    //Error refreshing data set
                    notificationFactory.error('Can not retrive data from the server now, please check internet connections and try again');
                });
        }

        ///////////////////////////////Remove Data
        $scope.Remove = function (media) {
            mediaDataServices.deleteMediaData(media)
                .then(function (result) {
                    //@ Success                   
                   notificationFactory.success('media successfully removed');             

                }, function (a) {
                    //@ Error
                    notificationFactory.error("Error occored while removing media");
                });
        }
        

        $scope.Goto = function (url) {
            $window.location = url;
        };

        $scope.activeTab = 1;

        $scope.selectedTab = function (setTab) {
            $scope.activeTab = setTab;
        };
    }
})();
