﻿(function () {
    'use strict';

    var controllerId = 'mediaNewEditController';

    // TODO: replace app with your module name
    churchplusapp.controller(controllerId,
        ['$scope', '$window', '$routeParams', 'mediaDataServices', 'notificationFactory', 'dataservices', '$upload', '$sce', mediaNewEditController]);

    function mediaNewEditController($scope, $window, $routeParams, mediaDataServices, notificationFactory, dataservices, $upload, $sce) {

        $scope.mediaData = {};
        $scope.selectedFile = [];
        $scope.progress;
        $scope.showProgress = false;
        var optionsMediaType = getMediaTypes();


        if ($routeParams.id == null) {
            BindMediatype();
        }
        else {
            mediaDataServices.getSingleMediaData($routeParams.id).then(function (mediaData) {
                $scope.mediaData = mediaData;
                $scope.mediaData.filePath = $sce.trustAsResourceUrl(mediaData.filePath);
                BindMediatype();
            }, function () {
                //Use Toaster Alert Note
                notificationFactory.error("Getting the announcement Information, try again");
            })
        }

        ////////////////////// function for getting message types 
        
        function getMediaTypes() {
            var options = [];
            mediaDataServices.getAllMediaTypes().then(
                function (result) {
                    var data = mediaDataServices.mediaTypes;                   
                    for (var i = 0; i < data.length; i++) {
                        options.push({ id: data[i].id, text: data[i].text });
                        
                    }
                },
                function () { });
           
            return options;
        }       

        //////////////////// function for getting out media files       

        $scope.onFileSelect = function ($files) {
            for (var i = 0; i < $files.length; i++)
                $scope.selectedFile.push($files[i]);
            //console.log($scope.selectedFile);
        };
       

        ////////////////// function for saving media data
      

        $scope.Save = function () {            
            $scope.mediaData.mediaType = $('#typeSelect').select2('data').id;
            $scope.showProgress = true;
            $scope.upload = $upload.upload({

                url: 'api/MediaController/SaveMedia',
                method: "POST",
                file: $scope.selectedFile,
                data: { mediaData: $scope.mediaData }

            })
            .progress(function (evt) {               
                
             $scope.progress = parseInt(100.0 * evt.loaded / evt.total);                       

             //   console.log('percent: ' + parseInt(100.0 * evt.loaded / evt.total));               
            })
            .success(function (data, status, headers, config) {
                $scope.showProgress = false;
                if (data.mediaType == 0) {
                   
                    for (var i = 0; mediaDataServices.videoData.length > i; i++) {
                        if (mediaDataServices.videoData[i].id == data.id) {
                            mediaDataServices.videoData.splice(i, 1);
                            break;
                        }
                    }

                    mediaDataServices.videoData.splice(0, 0, data);
                } else if (data.mediaType == 2) {

                    for (var i = 0; mediaDataServices.docsData.length > i; i++) {
                        if (mediaDataServices.docsData[i].id == data.id) {
                            mediaDataServices.docsData.splice(i, 1);
                            break;
                        }
                    }
                    mediaDataServices.docsData.splice(0, 0, data);

                } else if (data.mediaType == 1) {
                    for (var i = 0; mediaDataServices.audioData.length > i; i++) {
                        if (mediaDataServices.audioData[i].id == data.id) {
                            mediaDataServices.audioData.splice(i, 1);
                            break;
                        }
                    }
                    mediaDataServices.audioData.splice(0, 0, data);

                } else if (data.mediaType == 3) {
                    for (var i = 0; mediaDataServices.pictureData.length > i; i++) {
                        if (mediaDataServices.pictureData[i].id == data.id) {
                            mediaDataServices.pictureData.splice(i, 1);
                            break;
                        }
                    }
                    mediaDataServices.pictureData.splice(0, 0, data);

                }
                $window.location = "#/Media";
            });          

        }

        /////////////////////// function for cancel
        $scope.Cancel = function () {
            $scope.mediaData = {}
        };

        ///////////////////// function for enclosing links
        $scope.Goto = function (url) {
            $window.location = url;
        };


        ///////////////////// function for deleting media 
        $scope.Delete = function (media) {
            // $window.location = url;
            if (confirm('you are about to remove this information')) {

                mediaDataServices.deleteMediaData(media).then(function (result) {
                    notificationFactory.success("The Media Was Successfully Removed");
                    $scope.Goto('#/Media');


                }, function () { });
            }
        };

        

        ///////////////////////select 2 plugin for the media type field

        function BindMediatype() {
            $('#typeSelect').select2({
                placeholder: 'Select Type',
                multiple: false,                
                data: optionsMediaType,
                width: "100%",
                initSelection: function (element, callback) {
                    var returnType = $scope.mediaData.mediaType;
                    if (returnType != null) {
                        callback({
                            id: returnType,
                            text: optionsMediaType[returnType].text
                        });

                    }
                }
            }).select2('val', []);
        }
       
                  
    }
})();
