﻿(function () {
    'use strict';

    var controllerId = 'memberEditNewController';

    // TODO: replace app with your module name
    churchplusapp.controller(controllerId,
        ['$scope', 'dataservices', 'notificationFactory', 'membershipdataservices', '$routeParams', 'groupdataservices', '$window','cellFellowshipDataServices','$upload', memberEditNewController]);

    function memberEditNewController($scope, dataservices, notificationFactory, membershipdataservices, $routeParams, groupdataservices, $window, cellFellowshipDataServices, $upload) {
        $scope.title = 'memberEditNewController';
        $scope.activate = activate;
        $scope.selectedFile;

        $scope.SaveContact = SaveContact;
        $scope.RemoveMemberFromGroup = RemoveMemberFromGroup;
        $scope.RemoveFromHouseFellowship = RemoveFromHouseFellowship;
        $scope.SaveGroupMembership = SaveGroupMembership;
        $scope.SaveFellowshipMembership = SaveFellowshipMembership;
        $scope.SaveNote = SaveNote;
        $scope.RemoveNote = RemoveNote;
       
        $scope.houseFellowships=[];

        //$scope.DeleteContact = DeleteContact;
        // $scope.SendEmail = SendEmail;
        // $scope.SendSMS = SendSMS;

        $scope.person = { peopleInGroups: [], peopleInCenter: [] };
        $scope.lookUpData = dataservices.lookUpData;


        //load lookup values.
        if (dataservices.IsLookUpDataInitialized() == false) {
            dataservices.getLookUpInformation().then(function (data) {
                $scope.LookUpData = data;

                lookupMethod();
            }, function () {
                notificationFactory.error("Getting the membership classification information, try again");

            });
        } else {
            lookupMethod();

        }




        function activate() { }

        function SaveContact() {
            //map the fields to the person scope
            $scope.person.peopleClassificationID = $('#select-membershipClassifcation').val();
            $scope.person.ageGroupID = $('#select-ageGroupID').val();
            $scope.person.maritalStatusID = $('#select-maritalStatusID').val();
            $scope.person.genderID = $('#select-genderID').val();

            $scope.person.monthOfBirth = $('#select-monthOfBirth').val();
            $scope.person.dayOfBirth = $('#select-dayOfBirth').val();
            $scope.person.yearOfBirth = $('#select-yearOfBirth').val();

            $scope.person.dayOfWedding = $('#select-dayOfWedding').val();
            $scope.person.monthOfWedding = $('#select-monthOfWedding').val();
            $scope.person.yearOfWedding = $('#select-yearOfWedding').val();

            if ($scope.selectedFile) {
                $scope.upload = $upload.upload({

                    url: 'api/ImageUploadController/saveContactPix',
                    method: "POST",
                    data: { PictureBlobName: $scope.person.pictureBlobName },
                    file: $scope.selectedFile
                }).progress(function (evt) {

                    console.log('percent: ' + parseInt(100.0 * evt.loaded / evt.total));

                }).success(function (data, status, headers, config) {
                    //  var logo = data.replace(data[0], ' ').replace(data[data.length - 1], ' ');
                    $scope.person.pictureUrl = data[0];
                    $scope.person.pictureBlobName = data[1];

                    SavePerson();
                });

            } else {
                SavePerson();

            }
           

        }

        function SavePerson() {

            membershipdataservices.SaveMemberInformation($scope.person).then(function () {

                //successfully added a new contact to the system
                notificationFactory.success("Contact successfully added to contacts list");
                $window.location = "#/Membership/All";

            }, function () {

                notificationFactory.error("Contact Information was not saved successfully, please try again.");

            });
        }

        $scope.onFileSelect = function ($files) {
            $scope.selectedFile = $files[0];
        };
        function SaveGroupMembership() {
            var groupMembership = {};
            var peopleInGroup = {};
            var data = $('#groupMembership').select2('data');

            groupMembership.name = data.text;
            groupMembership.groupID = data.text;
            groupMembership.position = $scope.group.position;
            groupMembership.date = new Date();
            $scope.groups.push(groupMembership);

            //Attach this record to the peopleInGroups Collection of Persons Object
            peopleInGroup.groupID = data.id;
            peopleInGroup.personID = $scope.person.id;
            peopleInGroup.position = groupMembership.position;
            peopleInGroup.dateJoined = groupMembership.date;
            $scope.person.peopleInGroups.push(peopleInGroup);

        }
        function SaveFellowshipMembership() {
            var houseMembership = {};
            var peopleInCenter = {};
            var data = $('#HouseFellowship').select2('data');

            houseMembership.name = data.text;
            houseMembership.groupID = data.text;
            houseMembership.position = $scope.house.position;
            houseMembership.date = new Date();
            $scope.houseFellowships.push(houseMembership);

            //Attach this record to the peopleInGroups Collection of Persons Object
            peopleInCenter.cellCenterID = data.id;
            peopleInCenter.personID = $scope.person.id;
            peopleInCenter.position = houseMembership.position;
            peopleInCenter.dateJoined = houseMembership.date;
            $scope.person.peopleInCenter.push(peopleInCenter);

        }
        function SaveNote()
        {
            var note = {};
            $scope.note.dateCreated = new Date();
            note = $scope.note;
            $scope.note = {};
            $scope.person.notes.push(note);


        }
        //This function removes the selected group
        function RemoveMemberFromGroup(g) {

            if (g.id == null) {
                //
                $scope.groups.splice($scope.groups.indexOf(g), 1);
            }
            groupdataservices.removeGroupMemberData(g).then(function (result) {

                $scope.groups.splice($scope.groups.indexOf(g), 1);

            }, function () { });
        }
        function RemoveFromHouseFellowship(g)
        {
            if (g.id == null) {
                //
                $scope.houseFellowships.splice($scope.houseFellowships.indexOf(g), 1);
            }
            cellFellowshipDataServices.deleteHouseFellowshipMemberData(g.id).then(function (result) {

                $scope.houseFellowships.splice($scope.houseFellowships.indexOf(g), 1);

            }, function () { });
        }
        function RemoveNote(g)
        {
            if (g.id === undefined || g.id === null) {
                //
                $scope.person.notes.splice($scope.person.notes.indexOf(g), 1);
                console.log(g);

            } else {
                membershipdataservices.deleteNote(g.id).then(function (result) {

                    $scope.person.notes.splice($scope.person.notes.indexOf(g), 1);

                }, function () { });

            }
        }



        $(".select-full").select2({
            minimumResultsForSearch: "-1",
            width: "100%"
        });

        //databind for the group select
        var ddata = [];
        var hdata = [];

        if (groupdataservices.IsGroupDataInitialized() == false) {
            groupdataservices.getGroupsData().then(function () {
                groupDatabinding();

            }, function () { })
        } else {

            groupDatabinding();
        }

        if (cellFellowshipDataServices.isHouseFellowshipActivityDataInitialized() == false) {
            cellFellowshipDataServices.getAllHouseFellowshipData().then(function () {
                houseFellowshipDatabinding();

            }, function () { })
        } else {

            houseFellowshipDatabinding();
        }

        function lookupMethod() {
            $("#select-membershipClassifcation").select2({
                minimumResultsForSearch: "-1",
                placeHolder: '--select--',
                data: $scope.lookUpData.MembershipClassification,
                width: "100%"
            });
            $("#select-maritalStatusID").select2({
                minimumResultsForSearch: "-1",
                placeHolder: '--select--',
                data: $scope.lookUpData.MaritalStatus,
                width: "100%"
            });
            $("#select-ageGroupID").select2({
                minimumResultsForSearch: "-1",
                placeHolder: '--select--',
                data: $scope.lookUpData.AgeGroup,
                width: "100%"
            });


            if ($routeParams.id == null) {
                $scope.groups = [];
                $scope.person.peopleInCenter = [];
            }
            else {
                membershipdataservices.getSingleContactInformation($routeParams.id).then(function (person) {

                    $scope.person = person;

                    $('#select-membershipClassifcation').select2('val', person.peopleClassificationID);
                    $('#select-ageGroupID').select2('val', person.ageGroupID);
                    $('#select-maritalStatusID').select2('val', person.maritalStatusID);

                    $('#select-genderID').select2("val", person.genderID);

                    $('#select-monthOfBirth').select2('val', person.monthOfBirth);
                    $('#select-dayOfBirth').select2('val', person.dayOfBirth);
                    $('#select-yearOfBirth').select2('val', person.yearOfBirth);

                    $('#select-dayOfWedding').select2('val', person.dayOfWedding);
                    $('#select-monthOfWedding').select2('val', person.monthOfWedding);
                    $('#select-yearOfWedding').select2('val', person.yearOfWedding);

                }, function () {
                    //Use Toaster Alert Note
                    notificationFactory.error("Getting the contact Information, try again");

                })

                groupdataservices.getGroupsByMemberID($routeParams.id).then(function (result) {
                    $scope.groups = result;

                }, function () {


                });

                cellFellowshipDataServices.getHouseFellowshipsBelongedByAMember($routeParams.id).then(function (result) {
                   // $scope.person.peopleInCenter = [];
                    $scope.houseFellowships = result;
                }, function () { });
            }
        }
        function groupDatabinding() {
            for (var i = 0; i < groupdataservices.groups.length; i++) {
                var data = {};
                data.id = groupdataservices.groups[i].id;
                data.text = groupdataservices.groups[i].name;
                ddata.push(data);

            }
            $('#groupMembership')
        .select2({
            placeholder: 'Select group',
            data: ddata,
            width: "100%"
        }
        );
        }
        function houseFellowshipDatabinding() {
            for (var i = 0; i < cellFellowshipDataServices.houseFellowshipData.length; i++) {
                var data = {};

                data.id = cellFellowshipDataServices.houseFellowshipData[i].id;
                data.text = cellFellowshipDataServices.houseFellowshipData[i].name;
                hdata.push(data);

            }
            $('#HouseFellowship')
        .select2({
            placeholder: 'Select Fellowship',
            data: hdata,
            width: "100%"
        }
        );
        }
    }
})();
